/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.request.websockets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.SSLException;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.events.ExceptionEvent;
import pro.gravit.launcher.events.NotificationEvent;
import pro.gravit.launcher.events.SignalEvent;
import pro.gravit.launcher.events.request.AdditionalDataRequestEvent;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.events.request.BatchProfileByUsernameRequestEvent;
import pro.gravit.launcher.events.request.CheckServerRequestEvent;
import pro.gravit.launcher.events.request.CurrentUserRequestEvent;
import pro.gravit.launcher.events.request.ErrorRequestEvent;
import pro.gravit.launcher.events.request.ExitRequestEvent;
import pro.gravit.launcher.events.request.FeaturesRequestEvent;
import pro.gravit.launcher.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.events.request.GetSecureLevelInfoRequestEvent;
import pro.gravit.launcher.events.request.HardwareReportRequestEvent;
import pro.gravit.launcher.events.request.JoinServerRequestEvent;
import pro.gravit.launcher.events.request.LauncherRequestEvent;
import pro.gravit.launcher.events.request.LogEvent;
import pro.gravit.launcher.events.request.PingServerReportRequestEvent;
import pro.gravit.launcher.events.request.PingServerRequestEvent;
import pro.gravit.launcher.events.request.ProfileByUUIDRequestEvent;
import pro.gravit.launcher.events.request.ProfileByUsernameRequestEvent;
import pro.gravit.launcher.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.events.request.RefreshTokenRequestEvent;
import pro.gravit.launcher.events.request.RegisterRequestEvent;
import pro.gravit.launcher.events.request.RestoreRequestEvent;
import pro.gravit.launcher.events.request.RestoreSessionRequestEvent;
import pro.gravit.launcher.events.request.SecurityReportRequestEvent;
import pro.gravit.launcher.events.request.ServerStatusRequestEvent;
import pro.gravit.launcher.events.request.SetProfileRequestEvent;
import pro.gravit.launcher.events.request.UpdateListRequestEvent;
import pro.gravit.launcher.events.request.UpdateRequestEvent;
import pro.gravit.launcher.events.request.VerifySecureLevelKeyRequestEvent;
import pro.gravit.launcher.hasher.HashedEntry;
import pro.gravit.launcher.hasher.HashedEntryAdapter;
import pro.gravit.launcher.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.GetAvailabilityAuthRequest;
import pro.gravit.launcher.request.websockets.ClientJSONPoint;
import pro.gravit.launcher.request.websockets.WebSocketRequest;
import pro.gravit.utils.ProviderMap;
import pro.gravit.utils.UniversalJsonAdapter;
import pro.gravit.utils.helper.LogHelper;

public abstract class ClientWebSocketService
extends ClientJSONPoint {
    public static final ProviderMap<WebSocketEvent> results = new ProviderMap();
    public static final ProviderMap<WebSocketRequest> requests = new ProviderMap();
    private static boolean resultsRegistered = false;
    public final Gson gson;
    public final Boolean onConnect;
    public OnCloseCallback onCloseCallback;
    public ReconnectCallback reconnectCallback;

    public ClientWebSocketService(String address) throws SSLException {
        super(ClientWebSocketService.createURL(address));
        this.gson = Launcher.gsonManager.gson;
        this.onConnect = true;
    }

    public static void appendTypeAdapters(GsonBuilder builder) {
        builder.registerTypeAdapter(HashedEntry.class, (Object)new HashedEntryAdapter());
        builder.registerTypeAdapter(WebSocketEvent.class, (Object)new UniversalJsonAdapter(results));
        builder.registerTypeAdapter(WebSocketRequest.class, (Object)new UniversalJsonAdapter(requests));
        builder.registerTypeAdapter(AuthRequest.AuthPasswordInterface.class, (Object)new UniversalJsonAdapter(AuthRequest.providers));
        builder.registerTypeAdapter(GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails.class, (Object)new UniversalJsonAdapter(GetAvailabilityAuthRequest.providers));
        builder.registerTypeAdapter(OptionalAction.class, (Object)new UniversalJsonAdapter(OptionalAction.providers));
        builder.registerTypeAdapter(OptionalTrigger.class, (Object)new UniversalJsonAdapter(OptionalTrigger.providers));
    }

    private static URI createURL(String address) {
        try {
            return new URI(address);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    void onMessage(String message) {
        WebSocketEvent result = (WebSocketEvent)this.gson.fromJson(message, WebSocketEvent.class);
        this.eventHandle(result);
    }

    public abstract <T extends WebSocketEvent> void eventHandle(T var1);

    @Override
    void onDisconnect() {
        LogHelper.info((String)"WebSocket client disconnect");
        if (this.onCloseCallback != null) {
            this.onCloseCallback.onClose(0, "unsupported param", !this.isClosed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onOpen() {
        Boolean bl = this.onConnect;
        synchronized (bl) {
            this.onConnect.notifyAll();
        }
    }

    public void registerRequests() {
    }

    public void registerResults() {
        if (!resultsRegistered) {
            results.register("auth", AuthRequestEvent.class);
            results.register("checkServer", CheckServerRequestEvent.class);
            results.register("joinServer", JoinServerRequestEvent.class);
            results.register("launcher", LauncherRequestEvent.class);
            results.register("profileByUsername", ProfileByUsernameRequestEvent.class);
            results.register("profileByUUID", ProfileByUUIDRequestEvent.class);
            results.register("batchProfileByUsername", BatchProfileByUsernameRequestEvent.class);
            results.register("profiles", ProfilesRequestEvent.class);
            results.register("setProfile", SetProfileRequestEvent.class);
            results.register("updateList", UpdateListRequestEvent.class);
            results.register("error", ErrorRequestEvent.class);
            results.register("update", UpdateRequestEvent.class);
            results.register("restoreSession", RestoreSessionRequestEvent.class);
            results.register("log", LogEvent.class);
            results.register("getAvailabilityAuth", GetAvailabilityAuthRequestEvent.class);
            results.register("exception", ExceptionEvent.class);
            results.register("register", RegisterRequestEvent.class);
            results.register("notification", NotificationEvent.class);
            results.register("signal", SignalEvent.class);
            results.register("exit", ExitRequestEvent.class);
            results.register("getSecureLevelInfo", GetSecureLevelInfoRequestEvent.class);
            results.register("verifySecureLevelKey", VerifySecureLevelKeyRequestEvent.class);
            results.register("securityReport", SecurityReportRequestEvent.class);
            results.register("hardwareReport", HardwareReportRequestEvent.class);
            results.register("serverStatus", ServerStatusRequestEvent.class);
            results.register("pingServerReport", PingServerReportRequestEvent.class);
            results.register("pingServer", PingServerRequestEvent.class);
            results.register("currentUser", CurrentUserRequestEvent.class);
            results.register("features", FeaturesRequestEvent.class);
            results.register("refreshToken", RefreshTokenRequestEvent.class);
            results.register("restore", RestoreRequestEvent.class);
            results.register("additionalData", AdditionalDataRequestEvent.class);
            resultsRegistered = true;
        }
    }

    public void waitIfNotConnected() {
    }

    public void sendObject(Object obj) throws IOException {
        this.waitIfNotConnected();
        if (this.ch == null || !this.ch.isActive()) {
            this.reconnectCallback.onReconnect();
        }
        this.send(this.gson.toJson(obj, WebSocketRequest.class));
    }

    public void sendObject(Object obj, Type type) throws IOException {
        this.waitIfNotConnected();
        if (this.ch == null || !this.ch.isActive()) {
            this.reconnectCallback.onReconnect();
        }
        this.send(this.gson.toJson(obj, type));
    }

    @FunctionalInterface
    public static interface OnCloseCallback {
        public void onClose(int var1, String var2, boolean var3);
    }

    public static interface ReconnectCallback {
        public void onReconnect() throws IOException;
    }

    @FunctionalInterface
    public static interface EventHandler {
        public <T extends WebSocketEvent> boolean eventHandle(T var1);
    }
}

