/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.request.websockets;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.CharsetUtil;
import java.util.concurrent.TimeUnit;
import pro.gravit.launcher.request.websockets.ClientJSONPoint;
import pro.gravit.utils.helper.LogHelper;

public class WebSocketClientHandler
extends SimpleChannelInboundHandler<Object> {
    private final WebSocketClientHandshaker handshaker;
    private final ClientJSONPoint clientJSONPoint;
    private ChannelPromise handshakeFuture;

    public WebSocketClientHandler(WebSocketClientHandshaker handshaker, ClientJSONPoint clientJSONPoint) {
        this.handshaker = handshaker;
        this.clientJSONPoint = clientJSONPoint;
    }

    public ChannelFuture handshakeFuture() {
        return this.handshakeFuture;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeFuture = ctx.newPromise();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.handshaker.handshake(ctx.channel());
        this.clientJSONPoint.onOpen();
        ctx.executor().scheduleWithFixedDelay(() -> ctx.channel().writeAndFlush((Object)new PingWebSocketFrame()), 20L, 20L, TimeUnit.SECONDS);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.clientJSONPoint.onDisconnect();
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        Channel ch = ctx.channel();
        if (!this.handshaker.isHandshakeComplete()) {
            this.handshaker.finishHandshake(ch, (FullHttpResponse)msg);
            this.handshakeFuture.setSuccess();
            return;
        }
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse response = (FullHttpResponse)msg;
            throw new Exception("Unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ')');
        }
        WebSocketFrame frame = (WebSocketFrame)msg;
        if (frame instanceof TextWebSocketFrame) {
            TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
            if (LogHelper.isDevEnabled()) {
                LogHelper.dev((String)"Message: %s", (Object[])new Object[]{textFrame.text()});
            }
            this.clientJSONPoint.onMessage(textFrame.text());
        } else if (frame instanceof PingWebSocketFrame) {
            frame.content().retain();
            ch.writeAndFlush((Object)new PongWebSocketFrame(frame.content()), ch.voidPromise());
        } else if (!(frame instanceof PongWebSocketFrame)) {
            if (frame instanceof CloseWebSocketFrame) {
                ch.close();
            } else if (frame instanceof BinaryWebSocketFrame) {
                // empty if block
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(cause);
        } else {
            LogHelper.error((Throwable)cause);
        }
        ctx.close();
    }
}

