/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.profiles.optional;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.optional.OptionalFile;
import pro.gravit.launcher.profiles.optional.actions.OptionalAction;

public class OptionalView {
    public Set<OptionalFile> enabled = new HashSet<OptionalFile>();
    public Map<OptionalFile, OptionalFileInstallInfo> installInfo = new HashMap<OptionalFile, OptionalFileInstallInfo>();
    public Set<OptionalFile> all;

    public OptionalView(ClientProfile profile) {
        this.all = profile.getOptional();
        for (OptionalFile f : this.all) {
            if (!f.mark) continue;
            this.enable(f, true, null);
        }
    }

    public OptionalView(OptionalView view) {
        this.enabled = new HashSet<OptionalFile>(view.enabled);
        this.installInfo = new HashMap<OptionalFile, OptionalFileInstallInfo>(view.installInfo);
        this.all = view.all;
    }

    public OptionalView(ClientProfile profile, OptionalView old) {
        this(profile);
        for (OptionalFile oldFile : old.all) {
            OptionalFile newFile = this.findByName(oldFile.name);
            if (newFile == null) continue;
            if (old.isEnabled(oldFile)) {
                this.enable(newFile, old.installInfo.get((Object)oldFile).isManual, (file, status) -> {});
                continue;
            }
            this.disable(newFile, (file, status) -> {});
        }
    }

    public <T extends OptionalAction> Set<T> getActionsByClass(Class<T> clazz) {
        HashSet<OptionalAction> results = new HashSet<OptionalAction>();
        for (OptionalFile e : this.enabled) {
            if (e.actions == null) continue;
            for (OptionalAction a : e.actions) {
                if (!clazz.isAssignableFrom(a.getClass())) continue;
                results.add(a);
            }
        }
        return results;
    }

    public OptionalFile findByName(String name) {
        for (OptionalFile file : this.all) {
            if (!name.equals(file.name)) continue;
            return file;
        }
        return null;
    }

    public boolean isEnabled(OptionalFile file) {
        return this.enabled.contains(file);
    }

    public Set<OptionalAction> getEnabledActions() {
        HashSet<OptionalAction> results = new HashSet<OptionalAction>();
        for (OptionalFile e : this.enabled) {
            if (e.actions == null) continue;
            results.addAll(e.actions);
        }
        return results;
    }

    public Set<OptionalAction> getDisabledActions() {
        HashSet<OptionalAction> results = new HashSet<OptionalAction>();
        for (OptionalFile e : this.all) {
            if (this.enabled.contains(e) || e.actions == null) continue;
            results.addAll(e.actions);
        }
        return results;
    }

    public void enable(OptionalFile file, boolean manual, BiConsumer<OptionalFile, Boolean> callback) {
        OptionalFileInstallInfo installInfo;
        if (this.enabled.contains(file)) {
            return;
        }
        this.enabled.add(file);
        if (callback != null) {
            callback.accept(file, true);
        }
        if ((installInfo = this.installInfo.get(file)) == null) {
            installInfo = new OptionalFileInstallInfo();
            this.installInfo.put(file, installInfo);
        }
        installInfo.isManual = manual;
        if (file.dependencies != null) {
            for (OptionalFile dep : file.dependencies) {
                this.enable(dep, false, callback);
            }
        }
        if (file.conflict != null) {
            for (OptionalFile conflict : file.conflict) {
                this.disable(conflict, callback);
            }
        }
    }

    public void disable(OptionalFile file, BiConsumer<OptionalFile, Boolean> callback) {
        if (!this.enabled.remove(file)) {
            return;
        }
        if (callback != null) {
            callback.accept(file, false);
        }
        for (OptionalFile dep : this.all) {
            if (dep.dependencies == null || !this.contains(file, dep.dependencies)) continue;
            this.disable(dep, callback);
        }
        if (file.dependencies != null) {
            for (OptionalFile dep : file.dependencies) {
                OptionalFileInstallInfo installInfo = this.installInfo.get(dep);
                if (installInfo == null || installInfo.isManual) continue;
                this.disable(file, callback);
            }
        }
    }

    private boolean contains(OptionalFile file, OptionalFile[] array) {
        for (OptionalFile e : array) {
            if (e != file) continue;
            return true;
        }
        return false;
    }

    public static class OptionalFileInstallInfo {
        public boolean isManual;
    }
}

