/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.profiles;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.hasher.FileNameMatcher;
import pro.gravit.launcher.profiles.ClientProfileVersions;
import pro.gravit.launcher.profiles.optional.OptionalDepend;
import pro.gravit.launcher.profiles.optional.OptionalFile;
import pro.gravit.launcher.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.VerifyHelper;
import pro.gravit.utils.launch.LaunchOptions;

public final class ClientProfile
implements Comparable<ClientProfile> {
    private static final FileNameMatcher ASSET_MATCHER = new FileNameMatcher(new String[0], new String[]{"indexes", "objects"}, new String[0]);
    @LauncherNetworkAPI
    private String title;
    @LauncherNetworkAPI
    private UUID uuid;
    @LauncherNetworkAPI
    private Version version;
    @LauncherNetworkAPI
    private String info;
    @LauncherNetworkAPI
    private String dir;
    @LauncherNetworkAPI
    private int sortIndex;
    @LauncherNetworkAPI
    private String assetIndex;
    @LauncherNetworkAPI
    private String assetDir;
    @LauncherNetworkAPI
    private List<String> update;
    @LauncherNetworkAPI
    private List<String> updateExclusions;
    @LauncherNetworkAPI
    private List<String> updateShared;
    @LauncherNetworkAPI
    private List<String> updateVerify;
    @LauncherNetworkAPI
    private Set<OptionalFile> updateOptional;
    @LauncherNetworkAPI
    private List<String> jvmArgs;
    @LauncherNetworkAPI
    private List<String> classPath;
    @LauncherNetworkAPI
    private List<String> modulePath = new ArrayList<String>();
    @LauncherNetworkAPI
    private List<String> modules = new ArrayList<String>();
    @LauncherNetworkAPI
    private List<String> altClassPath;
    @LauncherNetworkAPI
    private List<String> clientArgs;
    @LauncherNetworkAPI
    private List<String> compatClasses;
    @LauncherNetworkAPI
    private List<String> loadNatives;
    @LauncherNetworkAPI
    private Map<String, String> properties;
    @LauncherNetworkAPI
    private List<ServerProfile> servers;
    @LauncherNetworkAPI
    private ClassLoaderConfig classLoaderConfig;
    @LauncherNetworkAPI
    private List<CompatibilityFlags> flags;
    @LauncherNetworkAPI
    private int recommendJavaVersion = 8;
    @LauncherNetworkAPI
    private int minJavaVersion = 8;
    @LauncherNetworkAPI
    private int maxJavaVersion = 999;
    @LauncherNetworkAPI
    private ProfileDefaultSettings settings = new ProfileDefaultSettings();
    @LauncherNetworkAPI
    private boolean limited;
    @LauncherNetworkAPI
    private String mainClass;
    @LauncherNetworkAPI
    private String mainModule;
    @LauncherNetworkAPI
    private LaunchOptions.ModuleConf moduleConf;

    public ClientProfile() {
        this.update = new ArrayList<String>();
        this.updateExclusions = new ArrayList<String>();
        this.updateShared = new ArrayList<String>();
        this.updateVerify = new ArrayList<String>();
        this.updateOptional = new HashSet<OptionalFile>();
        this.jvmArgs = new ArrayList<String>();
        this.classPath = new ArrayList<String>();
        this.modulePath = new ArrayList<String>();
        this.altClassPath = new ArrayList<String>();
        this.clientArgs = new ArrayList<String>();
        this.compatClasses = new ArrayList<String>();
        this.properties = new HashMap<String, String>();
        this.servers = new ArrayList<ServerProfile>(1);
        this.classLoaderConfig = ClassLoaderConfig.LAUNCHER;
        this.flags = new ArrayList<CompatibilityFlags>();
    }

    public ClientProfile(List<String> update, List<String> updateExclusions, List<String> updateShared, List<String> updateVerify, Set<OptionalFile> updateOptional, List<String> jvmArgs, List<String> classPath, List<String> modulePath, List<String> modules, List<String> altClassPath, List<String> clientArgs, List<String> compatClasses, Map<String, String> properties, List<ServerProfile> servers, ClassLoaderConfig classLoaderConfig, List<CompatibilityFlags> flags, Version version, String assetIndex, String dir, String assetDir, int recommendJavaVersion, int minJavaVersion, int maxJavaVersion, ProfileDefaultSettings settings, int sortIndex, UUID uuid, String title, String info, String mainClass) {
        this.update = update;
        this.updateExclusions = updateExclusions;
        this.updateShared = updateShared;
        this.updateVerify = updateVerify;
        this.updateOptional = updateOptional;
        this.jvmArgs = jvmArgs;
        this.classPath = classPath;
        this.modulePath = modulePath;
        this.modules = modules;
        this.altClassPath = altClassPath;
        this.clientArgs = clientArgs;
        this.compatClasses = compatClasses;
        this.properties = properties;
        this.servers = servers;
        this.classLoaderConfig = classLoaderConfig;
        this.version = version;
        this.assetIndex = assetIndex;
        this.dir = dir;
        this.assetDir = assetDir;
        this.recommendJavaVersion = recommendJavaVersion;
        this.minJavaVersion = minJavaVersion;
        this.maxJavaVersion = maxJavaVersion;
        this.settings = settings;
        this.sortIndex = sortIndex;
        this.uuid = uuid;
        this.title = title;
        this.info = info;
        this.mainClass = mainClass;
        this.flags = flags;
    }

    public ServerProfile getDefaultServerProfile() {
        for (ServerProfile profile : this.servers) {
            if (!profile.isDefault) continue;
            return profile;
        }
        return null;
    }

    @Override
    public int compareTo(ClientProfile o) {
        return Integer.compare(this.getSortIndex(), o.getSortIndex());
    }

    public String getAssetIndex() {
        return this.assetIndex;
    }

    public FileNameMatcher getAssetUpdateMatcher() {
        return this.getVersion().compareTo(ClientProfileVersions.MINECRAFT_1_7_10) >= 0 ? ASSET_MATCHER : null;
    }

    public String[] getClassPath() {
        return this.classPath.toArray(new String[0]);
    }

    public List<String> getModulePath() {
        return Collections.unmodifiableList(this.modulePath);
    }

    public List<String> getModules() {
        return Collections.unmodifiableList(this.modules);
    }

    public String[] getAlternativeClassPath() {
        return this.altClassPath.toArray(new String[0]);
    }

    public String[] getClientArgs() {
        return this.clientArgs.toArray(new String[0]);
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getAssetDir() {
        return this.assetDir;
    }

    public List<String> getUpdateExclusions() {
        return Collections.unmodifiableList(this.updateExclusions);
    }

    public FileNameMatcher getClientUpdateMatcher() {
        String[] updateArray = this.update.toArray(new String[0]);
        String[] verifyArray = this.updateVerify.toArray(new String[0]);
        List<String> excludeList = this.updateExclusions;
        String[] exclusionsArray = excludeList.toArray(new String[0]);
        return new FileNameMatcher(updateArray, verifyArray, exclusionsArray);
    }

    public String[] getJvmArgs() {
        return this.jvmArgs.toArray(new String[0]);
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getMainModule() {
        return this.mainModule;
    }

    public LaunchOptions.ModuleConf getModuleConf() {
        return this.moduleConf;
    }

    public List<ServerProfile> getServers() {
        return this.servers;
    }

    public String getServerAddress() {
        ServerProfile profile = this.getDefaultServerProfile();
        return profile == null ? "localhost" : profile.serverAddress;
    }

    public Set<OptionalFile> getOptional() {
        return this.updateOptional;
    }

    public int getRecommendJavaVersion() {
        return this.recommendJavaVersion;
    }

    public int getMinJavaVersion() {
        return this.minJavaVersion;
    }

    public int getMaxJavaVersion() {
        return this.maxJavaVersion;
    }

    public ProfileDefaultSettings getSettings() {
        return this.settings;
    }

    public List<String> getLoadNatives() {
        return this.loadNatives;
    }

    public void updateOptionalGraph() {
        for (OptionalFile file : this.updateOptional) {
            int i;
            if (file.dependenciesFile != null) {
                file.dependencies = new OptionalFile[file.dependenciesFile.length];
                for (i = 0; i < file.dependenciesFile.length; ++i) {
                    file.dependencies[i] = this.getOptionalFile(file.dependenciesFile[i].name);
                }
            }
            if (file.conflictFile != null) {
                file.conflict = new OptionalFile[file.conflictFile.length];
                for (i = 0; i < file.conflictFile.length; ++i) {
                    file.conflict[i] = this.getOptionalFile(file.conflictFile[i].name);
                }
            }
            if (file.groupFile == null) continue;
            file.group = new OptionalFile[file.groupFile.length];
            for (i = 0; i < file.groupFile.length; ++i) {
                file.group[i] = this.getOptionalFile(file.groupFile[i].name);
            }
        }
    }

    public OptionalFile getOptionalFile(String file) {
        for (OptionalFile f : this.updateOptional) {
            if (!f.name.equals(file)) continue;
            return f;
        }
        return null;
    }

    public Collection<String> getShared() {
        return this.updateShared;
    }

    public int getServerPort() {
        ServerProfile profile = this.getDefaultServerProfile();
        return profile == null ? 25565 : profile.serverPort;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    @Deprecated
    public boolean isUpdateFastCheck() {
        return true;
    }

    public String toString() {
        return String.format("%s (%s)", this.title, this.uuid);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public boolean hasFlag(CompatibilityFlags flag) {
        return this.flags.contains((Object)flag);
    }

    public void verify() {
        this.getVersion();
        IOHelper.verifyFileName((String)this.getAssetIndex());
        VerifyHelper.verify((Object)this.getTitle(), (Predicate)VerifyHelper.NOT_EMPTY, (String)"Profile title can't be empty");
        VerifyHelper.verify((Object)this.getInfo(), (Predicate)VerifyHelper.NOT_EMPTY, (String)"Profile info can't be empty");
        VerifyHelper.verify((Object)this.getTitle(), (Predicate)VerifyHelper.NOT_EMPTY, (String)"Main class can't be empty");
        if (this.getUUID() == null) {
            throw new IllegalArgumentException("Profile UUID can't be null");
        }
        for (String s : this.update) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in update");
        }
        for (String s : this.updateVerify) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in updateVerify");
        }
        for (String s : this.updateExclusions) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in updateExclusions");
        }
        for (String s : this.classPath) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in classPath");
        }
        for (String s : this.jvmArgs) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in jvmArgs");
        }
        for (String s : this.clientArgs) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in clientArgs");
        }
        for (String s : this.compatClasses) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in compatClasses");
        }
        for (OptionalFile f : this.updateOptional) {
            if (f == null) {
                throw new IllegalArgumentException("Found null entry in updateOptional");
            }
            if (f.name == null) {
                throw new IllegalArgumentException("Optional: name must not be null");
            }
            if (f.conflictFile != null) {
                for (OptionalDepend optionalDepend : f.conflictFile) {
                    if (optionalDepend != null) continue;
                    throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.conflictFile", f.name));
                }
            }
            if (f.dependenciesFile != null) {
                for (OptionalDepend optionalDepend : f.dependenciesFile) {
                    if (optionalDepend != null) continue;
                    throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.dependenciesFile", f.name));
                }
            }
            if (f.groupFile != null) {
                for (OptionalDepend optionalDepend : f.groupFile) {
                    if (optionalDepend != null) continue;
                    throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.groupFile", f.name));
                }
            }
            if (f.triggersList == null) continue;
            for (OptionalTrigger trigger : f.triggersList) {
                if (trigger != null) continue;
                throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.triggers", f.name));
            }
        }
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public void putProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public boolean containsProperty(String name) {
        return this.properties.containsKey(name);
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public List<String> getCompatClasses() {
        return Collections.unmodifiableList(this.compatClasses);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientProfile profile = (ClientProfile)o;
        return Objects.equals(this.uuid, profile.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public ClassLoaderConfig getClassLoaderConfig() {
        return this.classLoaderConfig;
    }

    public void setClassLoaderConfig(ClassLoaderConfig classLoaderConfig) {
        this.classLoaderConfig = classLoaderConfig;
    }

    public boolean isLimited() {
        return this.limited;
    }

    public List<CompatibilityFlags> getFlags() {
        return this.flags;
    }

    public static class ProfileDefaultSettings {
        public int ram;
        public boolean autoEnter;
        public boolean fullScreen;
    }

    public static enum ClassLoaderConfig {
        AGENT,
        LAUNCHER,
        MODULE,
        SYSTEM_ARGS;

    }

    public static class Version
    implements Comparable<Version> {
        private final long[] data;
        private final String original;
        private final boolean isObjectSerialized;

        public static Version of(String string) {
            String tmp = string.replaceAll("[^.0-9]", ".");
            String[] list = tmp.split("\\.");
            return new Version(Arrays.stream(list).filter(e -> !e.isEmpty()).mapToLong(Long::parseLong).toArray(), string);
        }

        private Version(long[] data, String str) {
            this.data = data;
            this.original = str;
            this.isObjectSerialized = false;
        }

        public Version(long[] data, String original, boolean isObjectSerialized) {
            this.data = data;
            this.original = original;
            this.isObjectSerialized = isObjectSerialized;
        }

        @Override
        public int compareTo(Version some) {
            int result = 0;
            if (this.data.length == some.data.length) {
                for (int i = 0; i < this.data.length; ++i) {
                    result = Long.compare(this.data[i], some.data[i]);
                    if (result == 0) continue;
                    return result;
                }
            } else if (this.data.length < some.data.length) {
                int i;
                for (i = 0; i < this.data.length; ++i) {
                    result = Long.compare(this.data[i], some.data[i]);
                    if (result == 0) continue;
                    return result;
                }
                for (i = this.data.length; i < some.data.length; ++i) {
                    if (some.data[i] <= 0L) continue;
                    return -1;
                }
            } else {
                int i;
                for (i = 0; i < some.data.length; ++i) {
                    result = Long.compare(this.data[i], some.data[i]);
                    if (result == 0) continue;
                    return result;
                }
                for (i = some.data.length; i < this.data.length; ++i) {
                    if (this.data[i] <= 0L) continue;
                    return 1;
                }
            }
            return result;
        }

        public String toCleanString() {
            return Version.join(this.data);
        }

        private static String join(long[] data) {
            return String.join((CharSequence)".", (CharSequence[])Arrays.stream(data).mapToObj(String::valueOf).toArray(String[]::new));
        }

        public String toString() {
            return this.original;
        }

        public static class GsonSerializer
        implements JsonSerializer<Version>,
        JsonDeserializer<Version> {
            public Version deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (json.isJsonObject()) {
                    JsonObject object = json.getAsJsonObject();
                    String name = object.get("name").getAsString();
                    long[] list = (long[])context.deserialize(object.get("data"), long[].class);
                    return new Version(list, name, true);
                }
                if (json.isJsonArray()) {
                    long[] list = (long[])context.deserialize(json, long[].class);
                    return new Version(list, Version.join(list), false);
                }
                return Version.of(json.getAsString());
            }

            public JsonElement serialize(Version src, Type typeOfSrc, JsonSerializationContext context) {
                if (src.isObjectSerialized) {
                    JsonObject object = new JsonObject();
                    object.add("name", (JsonElement)new JsonPrimitive(src.original));
                    JsonArray array = new JsonArray();
                    for (long l : src.data) {
                        array.add((Number)l);
                    }
                    object.add("data", (JsonElement)array);
                    return object;
                }
                return new JsonPrimitive(src.toString());
            }
        }
    }

    public static class ServerProfile {
        public String name;
        public String serverAddress;
        public int serverPort;
        public boolean isDefault = true;
        public int protocol = -1;
        public boolean socketPing = true;

        public ServerProfile() {
        }

        public ServerProfile(String name, String serverAddress, int serverPort) {
            this.name = name;
            this.serverAddress = serverAddress;
            this.serverPort = serverPort;
        }

        public ServerProfile(String name, String serverAddress, int serverPort, boolean isDefault) {
            this.name = name;
            this.serverAddress = serverAddress;
            this.serverPort = serverPort;
            this.isDefault = isDefault;
        }

        public InetSocketAddress toSocketAddress() {
            return InetSocketAddress.createUnresolved(this.serverAddress, this.serverPort);
        }
    }

    public static enum CompatibilityFlags {
        LEGACY_NATIVES_DIR,
        CLASS_CONTROL_API,
        ENABLE_HACKS,
        WAYLAND_USE_CUSTOM_GLFW;

    }
}

