/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.profiles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.optional.OptionalFile;
import pro.gravit.utils.launch.LaunchOptions;

public class ClientProfileBuilder {
    private String title;
    private UUID uuid;
    private ClientProfile.Version version;
    private String info;
    private String dir;
    private int sortIndex;
    private String assetIndex;
    private String assetDir;
    private List<String> update;
    private List<String> updateExclusions;
    private List<String> updateVerify;
    private Set<OptionalFile> updateOptional;
    private List<String> jvmArgs;
    private List<String> classPath;
    private List<String> altClassPath;
    private List<String> clientArgs;
    private List<String> compatClasses;
    private List<String> loadNatives;
    private Map<String, String> properties;
    private List<ClientProfile.ServerProfile> servers;
    private ClientProfile.ClassLoaderConfig classLoaderConfig;
    private List<ClientProfile.CompatibilityFlags> flags;
    private int recommendJavaVersion;
    private int minJavaVersion;
    private int maxJavaVersion;
    private ClientProfile.ProfileDefaultSettings settings;
    private boolean limited;
    private String mainClass;
    private String mainModule;
    private LaunchOptions.ModuleConf moduleConf;

    public ClientProfileBuilder() {
        this.update = new ArrayList<String>();
        this.updateExclusions = new ArrayList<String>();
        this.updateVerify = new ArrayList<String>();
        this.updateOptional = new HashSet<OptionalFile>();
        this.jvmArgs = new ArrayList<String>();
        this.classPath = new ArrayList<String>();
        this.altClassPath = new ArrayList<String>();
        this.clientArgs = new ArrayList<String>();
        this.compatClasses = new ArrayList<String>();
        this.loadNatives = new ArrayList<String>();
        this.properties = new HashMap<String, String>();
        this.servers = new ArrayList<ClientProfile.ServerProfile>();
        this.flags = new ArrayList<ClientProfile.CompatibilityFlags>();
        this.settings = new ClientProfile.ProfileDefaultSettings();
        this.recommendJavaVersion = 21;
        this.minJavaVersion = 17;
        this.maxJavaVersion = 999;
        this.classLoaderConfig = ClientProfile.ClassLoaderConfig.LAUNCHER;
    }

    public ClientProfileBuilder(ClientProfile profile) {
        this.title = profile.getTitle();
        this.uuid = profile.getUUID();
        this.version = profile.getVersion();
        this.info = profile.getInfo();
        this.dir = profile.getDir();
        this.sortIndex = profile.getSortIndex();
        this.assetIndex = profile.getAssetIndex();
        this.assetDir = profile.getAssetDir();
        this.update = new ArrayList<String>(profile.getUpdate());
        this.updateExclusions = new ArrayList<String>(profile.getUpdateExclusions());
        this.updateVerify = new ArrayList<String>(profile.getUpdateVerify());
        this.updateOptional = new HashSet<OptionalFile>(profile.getOptional());
        this.jvmArgs = new ArrayList<String>(profile.getJvmArgs());
        this.classPath = new ArrayList<String>(profile.getClassPath());
        this.altClassPath = new ArrayList<String>(profile.getAlternativeClassPath());
        this.clientArgs = new ArrayList<String>(profile.getClientArgs());
        this.compatClasses = new ArrayList<String>(profile.getCompatClasses());
        this.loadNatives = new ArrayList<String>(profile.getLoadNatives());
        this.properties = new HashMap<String, String>(profile.getProperties());
        this.servers = new ArrayList<ClientProfile.ServerProfile>(profile.getServers());
        this.flags = new ArrayList<ClientProfile.CompatibilityFlags>(profile.getFlags());
        this.recommendJavaVersion = profile.getRecommendJavaVersion();
        this.minJavaVersion = profile.getMinJavaVersion();
        this.maxJavaVersion = profile.getMaxJavaVersion();
        this.settings = profile.getSettings();
        this.limited = profile.isLimited();
        this.mainClass = profile.getMainClass();
        this.mainModule = profile.getMainModule();
        this.moduleConf = profile.getModuleConf();
    }

    public ClientProfileBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public ClientProfileBuilder setUuid(UUID uuid) {
        this.uuid = uuid;
        return this;
    }

    public ClientProfileBuilder setVersion(ClientProfile.Version version) {
        this.version = version;
        return this;
    }

    public ClientProfileBuilder setInfo(String info) {
        this.info = info;
        return this;
    }

    public ClientProfileBuilder setDir(String dir) {
        this.dir = dir;
        return this;
    }

    public ClientProfileBuilder setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
        return this;
    }

    public ClientProfileBuilder setAssetIndex(String assetIndex) {
        this.assetIndex = assetIndex;
        return this;
    }

    public ClientProfileBuilder setAssetDir(String assetDir) {
        this.assetDir = assetDir;
        return this;
    }

    public ClientProfileBuilder setUpdate(List<String> update) {
        this.update = update;
        return this;
    }

    public ClientProfileBuilder update(String value) {
        this.update.add(value);
        return this;
    }

    public ClientProfileBuilder setUpdateExclusions(List<String> updateExclusions) {
        this.updateExclusions = updateExclusions;
        return this;
    }

    public ClientProfileBuilder updateExclusions(String value) {
        this.updateExclusions.add(value);
        return this;
    }

    public ClientProfileBuilder setUpdateVerify(List<String> updateVerify) {
        this.updateVerify = updateVerify;
        return this;
    }

    public ClientProfileBuilder updateVerify(String value) {
        this.updateVerify.add(value);
        return this;
    }

    public ClientProfileBuilder setUpdateOptional(Set<OptionalFile> updateOptional) {
        this.updateOptional = updateOptional;
        return this;
    }

    public ClientProfileBuilder updateOptional(OptionalFile value) {
        this.updateOptional.add(value);
        return this;
    }

    public ClientProfileBuilder setJvmArgs(List<String> jvmArgs) {
        this.jvmArgs = jvmArgs;
        return this;
    }

    public ClientProfileBuilder jvmArg(String value) {
        this.jvmArgs.add(value);
        return this;
    }

    public ClientProfileBuilder setClassPath(List<String> classPath) {
        this.classPath = classPath;
        return this;
    }

    public ClientProfileBuilder classPath(String value) {
        this.classPath.add(value);
        return this;
    }

    public ClientProfileBuilder setAltClassPath(List<String> altClassPath) {
        this.altClassPath = altClassPath;
        return this;
    }

    public ClientProfileBuilder altClassPath(String value) {
        this.altClassPath.add(value);
        return this;
    }

    public ClientProfileBuilder setClientArgs(List<String> clientArgs) {
        this.clientArgs = clientArgs;
        return this;
    }

    public ClientProfileBuilder clientArg(String value) {
        this.clientArgs.add(value);
        return this;
    }

    public ClientProfileBuilder setCompatClasses(List<String> compatClasses) {
        this.compatClasses = compatClasses;
        return this;
    }

    public ClientProfileBuilder compatClass(String value) {
        this.compatClasses.add(value);
        return this;
    }

    public ClientProfileBuilder setLoadNatives(List<String> loadNatives) {
        this.loadNatives = loadNatives;
        return this;
    }

    public ClientProfileBuilder loadNatives(String value) {
        this.loadNatives.add(value);
        return this;
    }

    public ClientProfileBuilder setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public ClientProfileBuilder property(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public ClientProfileBuilder setServers(List<ClientProfile.ServerProfile> servers) {
        this.servers = servers;
        return this;
    }

    public ClientProfileBuilder server(ClientProfile.ServerProfile value) {
        this.servers.add(value);
        return this;
    }

    public ClientProfileBuilder setClassLoaderConfig(ClientProfile.ClassLoaderConfig classLoaderConfig) {
        this.classLoaderConfig = classLoaderConfig;
        return this;
    }

    public ClientProfileBuilder setFlags(List<ClientProfile.CompatibilityFlags> flags) {
        this.flags = flags;
        return this;
    }

    public ClientProfileBuilder flag(ClientProfile.CompatibilityFlags value) {
        this.flags.add(value);
        return this;
    }

    public ClientProfileBuilder setRecommendJavaVersion(int recommendJavaVersion) {
        this.recommendJavaVersion = recommendJavaVersion;
        return this;
    }

    public ClientProfileBuilder setMinJavaVersion(int minJavaVersion) {
        this.minJavaVersion = minJavaVersion;
        return this;
    }

    public ClientProfileBuilder setMaxJavaVersion(int maxJavaVersion) {
        this.maxJavaVersion = maxJavaVersion;
        return this;
    }

    public ClientProfileBuilder setSettings(ClientProfile.ProfileDefaultSettings settings) {
        this.settings = settings;
        return this;
    }

    public ClientProfileBuilder setLimited(boolean limited) {
        this.limited = limited;
        return this;
    }

    public ClientProfileBuilder setMainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public ClientProfileBuilder setMainModule(String mainModule) {
        this.mainModule = mainModule;
        return this;
    }

    public ClientProfileBuilder setModuleConf(LaunchOptions.ModuleConf moduleConf) {
        this.moduleConf = moduleConf;
        return this;
    }

    public ClientProfile createClientProfile() {
        return new ClientProfile(this.title, this.uuid, this.version, this.info, this.dir, this.sortIndex, this.assetIndex, this.assetDir, this.update, this.updateExclusions, this.updateVerify, this.updateOptional, this.jvmArgs, this.classPath, this.altClassPath, this.clientArgs, this.compatClasses, this.loadNatives, this.properties, this.servers, this.classLoaderConfig, this.flags, this.recommendJavaVersion, this.minJavaVersion, this.maxJavaVersion, this.settings, this.limited, this.mainClass, this.mainModule, this.moduleConf);
    }
}

