/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.modules;

import java.util.ArrayList;
import java.util.List;
import pro.gravit.launcher.base.modules.LauncherInitContext;
import pro.gravit.launcher.base.modules.LauncherModuleInfo;
import pro.gravit.launcher.base.modules.LauncherModulesContext;
import pro.gravit.launcher.base.modules.LauncherModulesManager;
import pro.gravit.launcher.base.modules.ModulesConfigManager;
import pro.gravit.launcher.core.LauncherTrustManager;
import pro.gravit.utils.Version;

public abstract class LauncherModule {
    protected final LauncherModuleInfo moduleInfo;
    private final List<EventEntity<? extends Event>> eventList = new ArrayList<EventEntity<? extends Event>>(4);
    protected LauncherModulesManager modulesManager;
    protected ModulesConfigManager modulesConfigManager;
    protected InitStatus initStatus = InitStatus.CREATED;
    private LauncherModulesContext context;
    private LauncherTrustManager.CheckClassResult checkResult;

    protected LauncherModule() {
        this.moduleInfo = new LauncherModuleInfo("UnknownModule");
    }

    protected LauncherModule(LauncherModuleInfo info) {
        this.moduleInfo = info;
    }

    public final LauncherModuleInfo getModuleInfo() {
        return this.moduleInfo;
    }

    public InitStatus getInitStatus() {
        return this.initStatus;
    }

    public void setInitStatus(InitStatus initStatus) {
        this.initStatus = initStatus;
    }

    public final void setContext(LauncherModulesContext context) {
        if (this.context != null) {
            throw new IllegalStateException("Module already set context");
        }
        this.context = context;
        this.modulesManager = context.getModulesManager();
        this.modulesConfigManager = context.getModulesConfigManager();
        this.setInitStatus(InitStatus.PRE_INIT_WAIT);
    }

    public final LauncherTrustManager.CheckClassResultType getCheckStatus() {
        if (this.checkResult == null) {
            return null;
        }
        return this.checkResult.type;
    }

    public final LauncherTrustManager.CheckClassResult getCheckResult() {
        if (this.checkResult == null) {
            return null;
        }
        return new LauncherTrustManager.CheckClassResult(this.checkResult);
    }

    public final void setCheckResult(LauncherTrustManager.CheckClassResult result) {
        if (this.checkResult != null) {
            throw new IllegalStateException("Module already set check result");
        }
        this.checkResult = result;
    }

    protected final void requireModule(String name, Version minVersion) {
        if (this.context == null) {
            throw new IllegalStateException("requireModule must be used in init() phase");
        }
        LauncherModule module = this.context.getModulesManager().getModule(name);
        this.requireModule(module, minVersion, name);
    }

    protected final <T extends LauncherModule> T requireModule(Class<? extends T> clazz, Version minVersion) {
        if (this.context == null) {
            throw new IllegalStateException("requireModule must be used in init() phase");
        }
        T module = this.context.getModulesManager().getModule(clazz);
        this.requireModule((LauncherModule)module, minVersion, clazz.getName());
        return module;
    }

    protected LauncherModulesContext getContext() {
        return this.context;
    }

    private void requireModule(LauncherModule module, Version minVersion, String requiredModuleName) {
        if (module == null) {
            throw new RuntimeException(String.format("Module %s required %s v%s or higher", this.moduleInfo.name, requiredModuleName, minVersion.getVersionString()));
        }
        if (module.moduleInfo.version.isLowerThan(minVersion)) {
            throw new RuntimeException(String.format("Module %s required %s v%s or higher (current version %s)", this.moduleInfo.name, requiredModuleName, minVersion.getVersionString(), module.moduleInfo.version.getVersionString()));
        }
    }

    public void preInitAction() {
    }

    public final void preInit() {
        if (!this.initStatus.equals((Object)InitStatus.PRE_INIT_WAIT)) {
            throw new IllegalStateException("PreInit not allowed in current state");
        }
        this.initStatus = InitStatus.PRE_INIT;
        this.preInitAction();
        this.initStatus = InitStatus.INIT_WAIT;
    }

    public abstract void init(LauncherInitContext var1);

    protected <T extends Event> boolean registerEvent(EventHandler<T> handle, Class<T> tClass) {
        EventEntity<T> eventEntity = new EventEntity<T>(handle, tClass);
        this.eventList.add(eventEntity);
        return true;
    }

    public final <T extends Event> void callEvent(T event) {
        Class<?> tClass = event.getClass();
        for (EventEntity<? extends Event> entity : this.eventList) {
            if (!entity.clazz.isAssignableFrom(tClass)) continue;
            entity.handler.event(event);
            if (!event.isCancel()) continue;
            return;
        }
    }

    public static enum InitStatus {
        CREATED(false),
        PRE_INIT_WAIT(true),
        PRE_INIT(false),
        INIT_WAIT(true),
        INIT(false),
        FINISH(true);

        private final boolean isAvailable;

        private InitStatus(boolean b) {
            this.isAvailable = b;
        }

        public boolean isAvailable() {
            return this.isAvailable;
        }
    }

    private static final class EventEntity<T extends Event> {
        final Class<T> clazz;
        final EventHandler<T> handler;

        private EventEntity(EventHandler<T> handler, Class<T> clazz) {
            this.clazz = clazz;
            this.handler = handler;
        }
    }

    @FunctionalInterface
    public static interface EventHandler<T extends Event> {
        public void event(T var1);
    }

    public static class Event {
        protected boolean cancel = false;

        public boolean isCancel() {
            return this.cancel;
        }

        public void cancel() {
            this.cancel = true;
        }
    }
}

