/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.cert.CertificateException;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.modules.LauncherModule;
import pro.gravit.launcher.base.modules.LauncherModulesManager;
import pro.gravit.launcher.core.LauncherInject;
import pro.gravit.launcher.core.LauncherInjectionConstructor;
import pro.gravit.launcher.core.LauncherTrustManager;
import pro.gravit.launcher.core.serialize.HInput;
import pro.gravit.launcher.core.serialize.HOutput;
import pro.gravit.launcher.core.serialize.stream.StreamObject;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class LauncherConfig
extends StreamObject {
    @LauncherInject(value="launchercore.certificates")
    private static final List<byte[]> secureConfigCertificates = null;
    @LauncherInject(value="launcher.legacymodules")
    private static final List<Class<?>> modulesClasses = null;
    private static final MethodType VOID_TYPE = MethodType.methodType(Void.TYPE);
    @LauncherInject(value="launcher.projectName")
    public final String projectName;
    @LauncherInject(value="launcher.port")
    public final int clientPort;
    public final LauncherTrustManager trustManager;
    public final ECPublicKey ecdsaPublicKey;
    public final RSAPublicKey rsaPublicKey;
    public final Map<String, byte[]> runtime;
    @LauncherInject(value="runtimeconfig.secureCheckHash")
    public final String secureCheckHash;
    @LauncherInject(value="runtimeconfig.secureCheckSalt")
    public final String secureCheckSalt;
    @LauncherInject(value="runtimeconfig.passwordEncryptKey")
    public final String passwordEncryptKey;
    @LauncherInject(value="runtimeconfig.runtimeEncryptKey")
    public final String runtimeEncryptKey;
    @LauncherInject(value="launcher.address")
    public final String address;
    @LauncherInject(value="runtimeconfig.secretKeyClient")
    public String secretKeyClient;
    @LauncherInject(value="runtimeconfig.unlockSecret")
    public String unlockSecret;
    @LauncherInject(value="launchercore.env")
    public LauncherEnvironment environment;
    @LauncherInject(value="runtimeconfig.buildNumber")
    public long buildNumber;

    @LauncherInjectionConstructor
    public LauncherConfig(HInput input) throws IOException, InvalidKeySpecException {
        this.ecdsaPublicKey = SecurityHelper.toPublicECDSAKey((byte[])input.readByteArray(2048));
        this.rsaPublicKey = SecurityHelper.toPublicRSAKey((byte[])input.readByteArray(2048));
        this.secureCheckHash = null;
        this.secureCheckSalt = null;
        this.passwordEncryptKey = null;
        this.runtimeEncryptKey = null;
        this.projectName = null;
        this.clientPort = -1;
        this.secretKeyClient = null;
        try {
            this.trustManager = new LauncherTrustManager(secureConfigCertificates);
        }
        catch (CertificateException e) {
            throw new IOException(e);
        }
        this.address = null;
        this.environment = LauncherEnvironment.STD;
        Launcher.applyLauncherEnv(this.environment);
        int count = input.readLength(0);
        HashMap localResources = new HashMap(count);
        for (int i = 0; i < count; ++i) {
            String name = input.readString(255);
            VerifyHelper.putIfAbsent(localResources, (Object)name, (Object)input.readByteArray(2048), (String)String.format("Duplicate runtime resource: '%s'", name));
        }
        this.runtime = Collections.unmodifiableMap(localResources);
    }

    public LauncherConfig(String address, ECPublicKey ecdsaPublicKey, RSAPublicKey rsaPublicKey, Map<String, byte[]> runtime, String projectName) {
        this.address = address;
        this.ecdsaPublicKey = ecdsaPublicKey;
        this.rsaPublicKey = rsaPublicKey;
        this.runtime = Map.copyOf(runtime);
        this.projectName = projectName;
        this.clientPort = 32148;
        this.environment = LauncherEnvironment.STD;
        this.secureCheckSalt = null;
        this.secureCheckHash = null;
        this.passwordEncryptKey = null;
        this.runtimeEncryptKey = null;
        this.trustManager = null;
    }

    public LauncherConfig(String address, Map<String, byte[]> runtime, String projectName, LauncherEnvironment env, LauncherTrustManager trustManager) {
        this.address = address;
        this.runtime = Map.copyOf(runtime);
        this.projectName = projectName;
        this.clientPort = 32148;
        this.trustManager = trustManager;
        this.rsaPublicKey = null;
        this.ecdsaPublicKey = null;
        this.environment = env;
        this.secureCheckSalt = null;
        this.secureCheckHash = null;
        this.passwordEncryptKey = null;
        this.runtimeEncryptKey = null;
    }

    public static void initModules(LauncherModulesManager modulesManager) {
        if (JVMHelper.JVM_VERSION >= 17) {
            modulesClasses.addAll(ModernModulesClass.modulesClasses);
        }
        for (Class<?> clazz : modulesClasses) {
            try {
                modulesManager.loadModule((LauncherModule)MethodHandles.publicLookup().findConstructor(clazz, VOID_TYPE).invokeWithArguments(Collections.emptyList()));
            }
            catch (Throwable e) {
                LogHelper.error((Throwable)e);
            }
        }
        modulesClasses.clear();
    }

    public void write(HOutput output) throws IOException {
        output.writeByteArray(this.ecdsaPublicKey.getEncoded(), 2048);
        output.writeByteArray(this.rsaPublicKey.getEncoded(), 2048);
        Set<Map.Entry<String, byte[]>> entrySet = this.runtime.entrySet();
        output.writeLength(entrySet.size(), 0);
        for (Map.Entry<String, byte[]> entry : this.runtime.entrySet()) {
            output.writeString(entry.getKey(), 255);
            output.writeByteArray(entry.getValue(), 2048);
        }
    }

    public static enum LauncherEnvironment {
        DEV,
        DEBUG,
        STD,
        PROD;

    }

    private static class ModernModulesClass {
        @LauncherInject(value="launcher.modules")
        private static final List<Class<?>> modulesClasses = null;

        private ModernModulesClass() {
        }
    }
}

