/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.request.websockets;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.net.ssl.SSLException;
import pro.gravit.launcher.base.Downloader;
import pro.gravit.launcher.core.LauncherInject;
import pro.gravit.utils.helper.LogHelper;

public abstract class ClientJSONPoint
implements WebSocket.Listener {
    @LauncherInject(value="launcher.certificatePinning")
    private static boolean isCertificatePinning;
    private static final AtomicInteger counter;
    private final URI uri;
    public boolean isClosed;
    private final WebSocket.Builder webSocketBuilder;
    protected HttpClient httpClient;
    protected WebSocket webSocket;
    protected boolean ssl = false;
    protected int port;
    private final Object syncObject = new Object();
    private final Object sendSyncObject = new Object();
    private volatile StringBuilder builder = new StringBuilder();

    public ClientJSONPoint(String uri) throws SSLException {
        this(URI.create(uri));
    }

    public ClientJSONPoint(URI uri) {
        this.uri = uri;
        String protocol = uri.getScheme();
        if (!"ws".equals(protocol) && !"wss".equals(protocol)) {
            throw new IllegalArgumentException("Unsupported protocol: " + protocol);
        }
        if ("wss".equals(protocol)) {
            this.ssl = true;
        }
        this.port = uri.getPort() == -1 ? ("ws".equals(protocol) ? 80 : 443) : uri.getPort();
        try {
            HttpClient.Builder httpClientBuilder = HttpClient.newBuilder();
            if (isCertificatePinning) {
                httpClientBuilder = httpClientBuilder.sslContext(Downloader.makeSSLContext());
            }
            this.httpClient = httpClientBuilder.build();
            this.webSocketBuilder = this.httpClient.newWebSocketBuilder().connectTimeout(Duration.ofSeconds(30L));
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public void open() throws Exception {
        this.webSocket = this.webSocketBuilder.buildAsync(this.uri, this).get();
    }

    public void openAsync(Runnable onConnect, Consumer<Throwable> onFail) {
        ((CompletableFuture)this.webSocketBuilder.buildAsync(this.uri, this).thenAccept(e -> {
            this.webSocket = e;
            onConnect.run();
        })).exceptionally(ex -> {
            onFail.accept((Throwable)ex);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
        Object object = this.syncObject;
        synchronized (object) {
            this.builder.append(data);
            if (last) {
                String message = this.builder.toString();
                this.builder = new StringBuilder();
                LogHelper.dev((String)"Received %s", (Object[])new Object[]{message});
                this.onMessage(message);
            }
        }
        return WebSocket.Listener.super.onText(webSocket, data, last);
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
        this.onDisconnect(statusCode, reason);
        return WebSocket.Listener.super.onClose(webSocket, statusCode, reason);
    }

    @Override
    public void onError(WebSocket webSocket, Throwable error) {
        LogHelper.error((Throwable)error);
        WebSocket.Listener.super.onError(webSocket, error);
    }

    public void send(String text) {
        LogHelper.dev((String)"Send %s", (Object[])new Object[]{text});
        this.webSocket.sendText(text, true);
    }

    abstract void onMessage(String var1);

    abstract void onDisconnect(int var1, String var2);

    abstract void onOpen();

    public void close() throws InterruptedException {
        this.webSocket.abort();
    }

    static {
        counter = new AtomicInteger();
    }
}

