/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.hwid.HWIDProvider;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.events.PreConfigPhase;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.LaunchServerBuilder;
import pro.gravit.launchserver.StarterAgent;
import pro.gravit.launchserver.auth.handler.AuthHandler;
import pro.gravit.launchserver.auth.hwid.HWIDHandler;
import pro.gravit.launchserver.auth.permissions.PermissionsHandler;
import pro.gravit.launchserver.auth.protect.ProtectHandler;
import pro.gravit.launchserver.auth.provider.AuthProvider;
import pro.gravit.launchserver.auth.texture.TextureProvider;
import pro.gravit.launchserver.components.Component;
import pro.gravit.launchserver.config.LaunchServerConfig;
import pro.gravit.launchserver.config.LaunchServerRuntimeConfig;
import pro.gravit.launchserver.dao.provider.DaoProvider;
import pro.gravit.launchserver.manangers.LaunchServerGsonManager;
import pro.gravit.launchserver.modules.impl.LaunchServerModulesManager;
import pro.gravit.launchserver.socket.WebSocketService;
import pro.gravit.utils.command.CommandHandler;
import pro.gravit.utils.command.JLineCommandHandler;
import pro.gravit.utils.command.StdCommandHandler;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class LaunchServerStarter {
    public static void main(String[] args) throws Exception {
        LaunchServerRuntimeConfig runtimeConfig;
        LaunchServerConfig config;
        RSAPrivateKey privateKey;
        RSAPublicKey publicKey;
        JLineCommandHandler localCommandHandler;
        JVMHelper.checkStackTrace(LaunchServerStarter.class);
        JVMHelper.verifySystemProperties(LaunchServer.class, (boolean)true);
        LogHelper.addOutput((Path)IOHelper.WORKING_DIR.resolve("LaunchServer.log"));
        LogHelper.printVersion((String)"LaunchServer");
        LogHelper.printLicense((String)"LaunchServer");
        if (!StarterAgent.isAgentStarted()) {
            LogHelper.error((String)"StarterAgent is not started!");
            LogHelper.error((String)"You should add to JVM options this option: `-javaagent:LaunchServer.jar`");
        }
        Path dir = IOHelper.WORKING_DIR;
        Path publicKeyFile = dir.resolve("public.key");
        Path privateKeyFile = dir.resolve("private.key");
        LaunchServer.LaunchServerEnv env = LaunchServer.LaunchServerEnv.PRODUCTION;
        LaunchServerModulesManager modulesManager = new LaunchServerModulesManager(dir.resolve("modules"), dir.resolve("config"));
        modulesManager.autoload();
        modulesManager.initModules(null);
        LaunchServerStarter.registerAll();
        LaunchServerStarter.initGson(modulesManager);
        final Path configFile = IOHelper.exists((Path)dir.resolve("LaunchServer.conf")) ? dir.resolve("LaunchServer.conf") : dir.resolve("LaunchServer.json");
        final Path runtimeConfigFile = IOHelper.exists((Path)dir.resolve("RuntimeLaunchServer.conf")) ? dir.resolve("RuntimeLaunchServer.conf") : dir.resolve("RuntimeLaunchServer.json");
        try {
            Class.forName("org.jline.terminal.Terminal");
            localCommandHandler = new JLineCommandHandler();
            LogHelper.info((String)"JLine2 terminal enabled");
        }
        catch (ClassNotFoundException ignored) {
            localCommandHandler = new StdCommandHandler(true);
            LogHelper.warning((String)"JLine2 isn't in classpath, using std");
        }
        if (IOHelper.isFile((Path)publicKeyFile) && IOHelper.isFile((Path)privateKeyFile)) {
            LogHelper.info((String)"Reading RSA keypair");
            publicKey = SecurityHelper.toPublicRSAKey((byte[])IOHelper.read((Path)publicKeyFile));
            privateKey = SecurityHelper.toPrivateRSAKey((byte[])IOHelper.read((Path)privateKeyFile));
            if (!publicKey.getModulus().equals(privateKey.getModulus())) {
                throw new IOException("Private and public key modulus mismatch");
            }
        } else {
            LogHelper.info((String)"Generating RSA keypair");
            KeyPair pair = SecurityHelper.genRSAKeyPair();
            publicKey = (RSAPublicKey)pair.getPublic();
            privateKey = (RSAPrivateKey)pair.getPrivate();
            LogHelper.info((String)"Writing RSA keypair list");
            IOHelper.write((Path)publicKeyFile, (byte[])publicKey.getEncoded());
            IOHelper.write((Path)privateKeyFile, (byte[])privateKey.getEncoded());
        }
        modulesManager.invokeEvent((LauncherModule.Event)new PreConfigPhase());
        LaunchServerStarter.generateConfigIfNotExists(configFile, (CommandHandler)localCommandHandler, env);
        LogHelper.info((String)"Reading LaunchServer config file");
        try (BufferedReader reader = IOHelper.newReader((Path)configFile);){
            config = (LaunchServerConfig)Launcher.gsonManager.gson.fromJson((Reader)reader, LaunchServerConfig.class);
        }
        if (!Files.exists(runtimeConfigFile, new LinkOption[0])) {
            LogHelper.info((String)"Reset LaunchServer runtime config file");
            runtimeConfig = new LaunchServerRuntimeConfig();
            runtimeConfig.reset();
        } else {
            LogHelper.info((String)"Reading LaunchServer runtime config file");
            reader = IOHelper.newReader((Path)runtimeConfigFile);
            var14_13 = null;
            try {
                runtimeConfig = (LaunchServerRuntimeConfig)Launcher.gsonManager.gson.fromJson((Reader)reader, LaunchServerRuntimeConfig.class);
            }
            catch (Throwable throwable) {
                var14_13 = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (var14_13 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            var14_13.addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        LaunchServer.LaunchServerConfigManager launchServerConfigManager = new LaunchServer.LaunchServerConfigManager(){

            @Override
            public LaunchServerConfig readConfig() throws IOException {
                LaunchServerConfig config1;
                try (BufferedReader reader = IOHelper.newReader((Path)configFile);){
                    config1 = (LaunchServerConfig)Launcher.gsonManager.gson.fromJson((Reader)reader, LaunchServerConfig.class);
                }
                return config1;
            }

            @Override
            public LaunchServerRuntimeConfig readRuntimeConfig() throws IOException {
                LaunchServerRuntimeConfig config1;
                try (BufferedReader reader = IOHelper.newReader((Path)runtimeConfigFile);){
                    config1 = (LaunchServerRuntimeConfig)Launcher.gsonManager.gson.fromJson((Reader)reader, LaunchServerRuntimeConfig.class);
                }
                return config1;
            }

            @Override
            public void writeConfig(LaunchServerConfig config) throws IOException {
                try (BufferedWriter writer = IOHelper.newWriter((Path)configFile);){
                    if (Launcher.gsonManager.configGson != null) {
                        Launcher.gsonManager.configGson.toJson((Object)config, (Appendable)writer);
                    } else {
                        LogHelper.error((String)"Error writing LaunchServer runtime config file. Gson is null");
                    }
                }
            }

            @Override
            public void writeRuntimeConfig(LaunchServerRuntimeConfig config) throws IOException {
                try (BufferedWriter writer = IOHelper.newWriter((Path)runtimeConfigFile);){
                    if (Launcher.gsonManager.configGson != null) {
                        Launcher.gsonManager.configGson.toJson((Object)config, (Appendable)writer);
                    } else {
                        LogHelper.error((String)"Error writing LaunchServer runtime config file. Gson is null");
                    }
                }
            }
        };
        LaunchServer server = new LaunchServerBuilder().setDir(dir).setEnv(env).setCommandHandler((CommandHandler)localCommandHandler).setPrivateKey(privateKey).setPublicKey(publicKey).setRuntimeConfig(runtimeConfig).setConfig(config).setModulesManager(modulesManager).setLaunchServerConfigManager(launchServerConfigManager).build();
        server.run();
    }

    public static void initGson(LaunchServerModulesManager modulesManager) {
        Launcher.gsonManager = new LaunchServerGsonManager(modulesManager);
        Launcher.gsonManager.initGson();
    }

    public static void registerAll() {
        AuthHandler.registerHandlers();
        AuthProvider.registerProviders();
        TextureProvider.registerProviders();
        HWIDHandler.registerHandlers();
        PermissionsHandler.registerHandlers();
        Component.registerComponents();
        ProtectHandler.registerHandlers();
        WebSocketService.registerResponses();
        HWIDProvider.registerHWIDs();
        DaoProvider.registerProviders();
        AuthRequest.registerProviders();
    }

    public static void generateConfigIfNotExists(Path configFile, CommandHandler commandHandler, LaunchServer.LaunchServerEnv env) throws IOException {
        String address;
        if (IOHelper.isFile((Path)configFile)) {
            return;
        }
        LogHelper.info((String)"Creating LaunchServer config");
        LaunchServerConfig newConfig = LaunchServerConfig.getDefault(env);
        if (env.equals((Object)LaunchServer.LaunchServerEnv.TEST)) {
            address = "localhost";
            newConfig.setProjectName("test");
        } else {
            System.out.println("LaunchServer address(default: localhost): ");
            address = commandHandler.readLine();
            System.out.println("LaunchServer projectName: ");
            newConfig.setProjectName(commandHandler.readLine());
        }
        if (address == null || address.isEmpty()) {
            LogHelper.error((String)"Address null. Using localhost");
            address = "localhost";
        }
        if (newConfig.projectName == null || newConfig.projectName.isEmpty()) {
            LogHelper.error((String)"ProjectName null. Using MineCraft");
            newConfig.projectName = "MineCraft";
        }
        newConfig.netty.address = "ws://" + address + ":9274/api";
        newConfig.netty.downloadURL = "http://" + address + ":9274/%dirname%/";
        newConfig.netty.launcherURL = "http://" + address + ":9274/Launcher.jar";
        newConfig.netty.launcherEXEURL = "http://" + address + ":9274/Launcher.exe";
        LogHelper.info((String)"Writing LaunchServer config file");
        try (BufferedWriter writer = IOHelper.newWriter((Path)configFile);){
            Launcher.gsonManager.configGson.toJson((Object)newConfig, (Appendable)writer);
        }
    }
}

