/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.asm;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import pro.gravit.launchserver.asm.ClassMetadataReader;
import pro.gravit.utils.helper.IOHelper;

public final class NodeUtils {
    private NodeUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClassNode forClass(Class<?> cls, int flags) {
        try (InputStream in = cls.getClassLoader().getResourceAsStream(cls.getName().replace('.', '/') + ".class");){
            ClassNode ret = new ClassNode();
            new ClassReader(IOHelper.read((InputStream)in)).accept((ClassVisitor)ret, flags);
            ClassNode classNode = ret;
            return classNode;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ClassNode forClass(String clazz, int flags, ClassMetadataReader r) {
        try {
            ClassNode ret = new ClassNode();
            r.acceptVisitor(clazz, (ClassVisitor)ret, flags);
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<AnnotationNode> annots(String clazz, String method, ClassMetadataReader r) {
        if (clazz.startsWith("L")) {
            clazz = Type.getType((String)clazz).getInternalName();
        }
        try {
            ArrayList<AnnotationNode> ret = new ArrayList<AnnotationNode>();
            ClassNode n = NodeUtils.forClass(clazz, 3, r);
            if (n.visibleAnnotations != null) {
                ret.addAll(n.visibleAnnotations);
            }
            if (n.invisibleAnnotations != null) {
                ret.addAll(n.invisibleAnnotations);
            }
            for (MethodNode m : n.methods) {
                if (!method.equals(m.name)) continue;
                if (m.visibleAnnotations != null) {
                    ret.addAll(m.visibleAnnotations);
                }
                if (m.invisibleAnnotations == null) continue;
                ret.addAll(m.invisibleAnnotations);
            }
            return ret;
        }
        catch (Throwable e) {
            return Collections.emptyList();
        }
    }

    private static int doMethodEmulation(String desc) {
        int result = 0;
        Type returnType = Type.getReturnType((String)desc);
        if (returnType.getSort() == 7 || returnType.getSort() == 8) {
            ++result;
        }
        if (returnType.getSort() != 0) {
            ++result;
        }
        return result;
    }

    public static int opcodeEmulation(AbstractInsnNode e) {
        int stackSize = 0;
        switch (e.getOpcode()) {
            case 0: 
            case 47: 
            case 49: 
            case 95: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 132: 
            case 134: 
            case 138: 
            case 139: 
            case 143: 
            case 145: 
            case 146: 
            case 147: 
            case 167: 
            case 177: 
            case 188: 
            case 189: 
            case 190: 
            case 192: 
            case 193: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 25: 
            case 89: 
            case 90: 
            case 91: 
            case 133: 
            case 135: 
            case 140: 
            case 141: 
            case 187: {
                ++stackSize;
                break;
            }
            case 18: {
                LdcInsnNode ldc = (LdcInsnNode)e;
                if (ldc.cst instanceof Long || ldc.cst instanceof Double) {
                    ++stackSize;
                }
                ++stackSize;
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 22: 
            case 24: 
            case 92: 
            case 93: 
            case 94: {
                ++stackSize;
                ++stackSize;
                break;
            }
            case 182: 
            case 183: 
            case 185: {
                stackSize += NodeUtils.doMethodEmulation(((MethodInsnNode)e).desc);
                break;
            }
            case 184: {
                stackSize += NodeUtils.doMethodEmulation(((MethodInsnNode)e).desc);
                break;
            }
            case 186: {
                stackSize += NodeUtils.doMethodEmulation(((InvokeDynamicInsnNode)e).desc);
                break;
            }
            case 168: 
            case 169: {
                throw new RuntimeException("Did not expect JSR/RET instructions");
            }
        }
        return stackSize;
    }
}

