/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.provider;

import java.io.IOException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.password.AuthPlainPassword;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.provider.AuthProvider;
import pro.gravit.launchserver.auth.provider.AuthProviderResult;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public final class RequestAuthProvider
extends AuthProvider {
    private String url;
    private transient Pattern pattern;
    private String response;
    private boolean usePermission;

    @Override
    public void init(LaunchServer srv) {
        super.init(srv);
        if (this.url == null) {
            LogHelper.error((String)"[Verify][AuthProvider] url cannot be null");
        }
        if (this.response == null) {
            LogHelper.error((String)"[Verify][AuthProvider] response cannot be null");
        }
        this.pattern = Pattern.compile(this.response);
    }

    @Override
    public AuthProviderResult auth(String login, AuthRequest.AuthPasswordInterface password, String ip) throws IOException {
        if (!(password instanceof AuthPlainPassword)) {
            throw new AuthException("This password type not supported");
        }
        String currentResponse = IOHelper.request((URL)new URL(this.getFormattedURL(login, ((AuthPlainPassword)password).password, ip)));
        Matcher matcher = this.pattern.matcher(currentResponse);
        return matcher.matches() && matcher.groupCount() >= 1 ? new AuthProviderResult(matcher.group("username"), SecurityHelper.randomStringToken(), this.usePermission ? new ClientPermissions(Long.parseLong(matcher.group("permission"))) : this.srv.config.permissionsHandler.getPermissions(login)) : RequestAuthProvider.authError(currentResponse);
    }

    @Override
    public void close() {
    }

    private String getFormattedURL(String login, String password, String ip) {
        return CommonHelper.replace((String)this.url, (String[])new String[]{"login", IOHelper.urlEncode((String)login), "password", IOHelper.urlEncode((String)password), "ip", IOHelper.urlEncode((String)ip)});
    }
}

