/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary;

import java.io.IOException;
import java.nio.file.Path;
import net.sf.launch4j.Builder;
import net.sf.launch4j.Log;
import net.sf.launch4j.config.Config;
import net.sf.launch4j.config.ConfigPersister;
import net.sf.launch4j.config.Jre;
import net.sf.launch4j.config.LanguageID;
import net.sf.launch4j.config.VersionInfo;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.binary.LauncherBinary;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public final class EXEL4JLauncherBinary
extends LauncherBinary {
    private static final String DOWNLOAD_URL = "http://www.oracle.com/technetwork/java/javase/downloads/jre8-downloads-2133155.html";
    private final Path faviconFile;
    private static String VERSION = Version.getVersion().getVersionString();
    private static int BUILD = Version.getVersion().build;

    public EXEL4JLauncherBinary(LaunchServer server) {
        super(server, LauncherBinary.resolve(server, ".exe"));
        this.faviconFile = server.dir.resolve("favicon.ico");
    }

    @Override
    public void build() throws IOException {
        LogHelper.info((String)"Building launcher EXE binary file (Using Launch4J)");
        this.setConfig();
        Config config = ConfigPersister.getInstance().getConfig();
        if (IOHelper.isFile((Path)this.faviconFile)) {
            config.setIcon(this.faviconFile.toFile());
        } else {
            config.setIcon(null);
            LogHelper.warning((String)"Missing favicon.ico file");
        }
        Builder builder = new Builder((Log)Launch4JLog.INSTANCE);
        try {
            builder.build();
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    private void setConfig() {
        Config config = new Config();
        config.setChdir(".");
        config.setErrTitle("JVM Error");
        config.setDownloadUrl(DOWNLOAD_URL);
        config.setPriorityIndex(0);
        config.setHeaderType("gui");
        config.setStayAlive(false);
        config.setRestartOnCrash(false);
        Jre jre = new Jre();
        jre.setMinVersion("1.8.0");
        if (this.server.config.launch4j.setMaxVersion) {
            jre.setMaxVersion(this.server.config.launch4j.maxVersion);
        }
        jre.setRuntimeBits("64/32");
        jre.setJdkPreference("preferJre");
        config.setJre(jre);
        VersionInfo info = new VersionInfo();
        info.setProductName(this.server.config.launch4j.productName);
        info.setProductVersion(EXEL4JLauncherBinary.formatVars(this.server.config.launch4j.productVer));
        info.setFileDescription(this.server.config.launch4j.fileDesc);
        info.setFileVersion(EXEL4JLauncherBinary.formatVars(this.server.config.launch4j.fileVer));
        info.setCopyright(this.server.config.launch4j.copyright);
        info.setTrademarks(this.server.config.launch4j.trademarks);
        info.setInternalName(EXEL4JLauncherBinary.formatVars(this.server.config.launch4j.internalName));
        info.setTxtFileVersion(EXEL4JLauncherBinary.formatVars(this.server.config.launch4j.txtFileVersion));
        info.setTxtProductVersion(EXEL4JLauncherBinary.formatVars(this.server.config.launch4j.txtProductVersion));
        info.setOriginalFilename(this.syncBinaryFile.getFileName().toString());
        info.setLanguage(LanguageID.RUSSIAN);
        config.setVersionInfo(info);
        config.setDontWrapJar(false);
        config.setJar(this.server.launcherBinary.syncBinaryFile.toFile());
        config.setOutfile(this.syncBinaryFile.toFile());
        ConfigPersister.getInstance().setAntConfig(config, null);
    }

    public static String formatVars(String mask) {
        return String.format(mask, VERSION, BUILD);
    }

    private static final class Launch4JLog
    extends Log {
        private static final Launch4JLog INSTANCE = new Launch4JLog();

        private Launch4JLog() {
        }

        public void append(String s) {
            LogHelper.subInfo((String)s);
        }

        public void clear() {
        }
    }
}

