/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.binary.LauncherBinary;
import pro.gravit.launchserver.binary.tasks.AdditionalFixesApplyTask;
import pro.gravit.launchserver.binary.tasks.AttachJarsTask;
import pro.gravit.launchserver.binary.tasks.CompressBuildTask;
import pro.gravit.launchserver.binary.tasks.LauncherBuildTask;
import pro.gravit.launchserver.binary.tasks.MainBuildTask;
import pro.gravit.launchserver.binary.tasks.PrepareBuildTask;
import pro.gravit.launchserver.binary.tasks.ProGuardBuildTask;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public final class JARLauncherBinary
extends LauncherBinary {
    public final AtomicLong count = new AtomicLong(0L);
    public final Path runtimeDir;
    public final Path guardDir;
    public final Path buildDir;
    public List<LauncherBuildTask> tasks;
    public List<Path> coreLibs;
    public List<Path> addonLibs;

    public JARLauncherBinary(LaunchServer server) throws IOException {
        super(server, JARLauncherBinary.resolve(server, ".jar"));
        this.runtimeDir = server.dir.resolve("runtime");
        this.guardDir = server.dir.resolve("guard");
        this.buildDir = server.dir.resolve("build");
        this.tasks = new ArrayList<LauncherBuildTask>();
        this.coreLibs = new ArrayList<Path>();
        this.addonLibs = new ArrayList<Path>();
        if (!Files.isDirectory(this.buildDir, new LinkOption[0])) {
            Files.deleteIfExists(this.buildDir);
            Files.createDirectory(this.buildDir, new FileAttribute[0]);
        }
    }

    @Override
    public void init() {
        this.tasks.add(new PrepareBuildTask(this.server));
        this.tasks.add(new MainBuildTask(this.server));
        if (this.server.config.launcher.attachLibraryBeforeProGuard) {
            this.tasks.add(new AttachJarsTask(this.server));
        }
        this.tasks.add(new ProGuardBuildTask(this.server));
        this.tasks.add(new AdditionalFixesApplyTask(this.server));
        if (!this.server.config.launcher.attachLibraryBeforeProGuard) {
            this.tasks.add(new AttachJarsTask(this.server));
        }
        if (this.server.config.launcher.compress) {
            this.tasks.add(new CompressBuildTask(this.server));
        }
    }

    @Override
    public void build() throws IOException {
        long time_start;
        LogHelper.info((String)"Building launcher binary file");
        this.count.set(0L);
        Path thisPath = null;
        boolean isNeedDelete = false;
        long time_this = time_start = System.currentTimeMillis();
        for (LauncherBuildTask task : this.tasks) {
            LogHelper.subInfo((String)"Task %s", (Object[])new Object[]{task.getName()});
            Path oldPath = thisPath;
            thisPath = task.process(oldPath);
            long time_task_end = System.currentTimeMillis();
            long time_task = time_task_end - time_this;
            time_this = time_task_end;
            if (isNeedDelete && this.server.config.launcher.deleteTempFiles) {
                Files.deleteIfExists(oldPath);
            }
            isNeedDelete = task.allowDelete();
            LogHelper.subInfo((String)"Task %s processed from %d millis", (Object[])new Object[]{task.getName(), time_task});
        }
        long time_end = System.currentTimeMillis();
        if (isNeedDelete && this.server.config.launcher.deleteTempFiles) {
            IOHelper.move(thisPath, (Path)this.syncBinaryFile);
        } else {
            IOHelper.copy(thisPath, (Path)this.syncBinaryFile);
        }
        LogHelper.info((String)"Build successful from %d millis", (Object[])new Object[]{time_end - time_start});
    }

    public String nextName(String taskName) {
        return String.format("Launcher-%s-%d.jar", taskName, this.count.getAndIncrement());
    }

    public Path nextPath(String taskName) {
        return this.buildDir.resolve(this.nextName(taskName));
    }

    public Path nextPath(LauncherBuildTask task) {
        return this.nextPath(task.getName());
    }

    public Path nextLowerPath(LauncherBuildTask task) {
        return this.nextPath(CommonHelper.low((String)task.getName()));
    }
}

