/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary.tasks;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import pro.gravit.launcher.AutogenConfig;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.serialize.HOutput;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.asm.ClassMetadataReader;
import pro.gravit.launchserver.binary.BuildContext;
import pro.gravit.launchserver.binary.LauncherConfigurator;
import pro.gravit.launchserver.binary.tasks.LauncherBuildTask;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class MainBuildTask
implements LauncherBuildTask {
    private final LaunchServer server;
    public final ClassMetadataReader reader;

    private static ZipEntry newEntry(String fileName) {
        return IOHelper.newZipEntry((String)("runtime/" + fileName));
    }

    private static ZipEntry newGuardEntry(String fileName) {
        return IOHelper.newZipEntry((String)("guard/" + fileName));
    }

    public MainBuildTask(LaunchServer srv) {
        this.server = srv;
        this.reader = new ClassMetadataReader();
    }

    @Override
    public String getName() {
        return "MainBuild";
    }

    @Override
    public Path process(Path inputJar) throws IOException {
        Path outputJar = this.server.launcherBinary.nextPath("main");
        try (ZipOutputStream output = new ZipOutputStream(IOHelper.newOutput((Path)outputJar));){
            byte[] byArray;
            ClassNode cn = new ClassNode();
            new ClassReader(IOHelper.getResourceBytes((String)AutogenConfig.class.getName().replace('.', '/').concat(".class"))).accept((ClassVisitor)cn, 0);
            LauncherConfigurator launcherConfigurator = new LauncherConfigurator(cn);
            BuildContext context = new BuildContext(output, launcherConfigurator, this);
            this.server.buildHookManager.hook(context);
            launcherConfigurator.setAddress(this.server.config.netty.address);
            if (this.server.config.guardLicense != null) {
                launcherConfigurator.setGuardLicense(this.server.config.guardLicense.name, this.server.config.guardLicense.key, this.server.config.guardLicense.encryptKey);
            } else {
                launcherConfigurator.nullGuardLicense();
            }
            launcherConfigurator.setProjectName(this.server.config.projectName);
            launcherConfigurator.setSecretKey(SecurityHelper.randomStringAESKey());
            launcherConfigurator.setClientPort(32148 + SecurityHelper.newRandom().nextInt(512));
            launcherConfigurator.setGuardType(this.server.config.launcher.guardType);
            launcherConfigurator.setWarningMissArchJava(this.server.config.launcher.warningMissArchJava);
            launcherConfigurator.setEnv(this.server.config.env);
            String launcherSalt = SecurityHelper.randomStringToken();
            byte[] launcherSecureHash = SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.SHA256, (String)this.server.runtime.clientCheckSecret.concat(".").concat(launcherSalt));
            launcherConfigurator.setSecureCheck(Base64.getEncoder().encodeToString(launcherSecureHash), launcherSalt);
            if (this.server.runtime.oemUnlockKey == null) {
                this.server.runtime.oemUnlockKey = SecurityHelper.randomStringToken();
            }
            launcherConfigurator.setOemUnlockKey(this.server.runtime.oemUnlockKey);
            this.server.buildHookManager.registerAllClientModuleClass(launcherConfigurator);
            this.reader.getCp().add(new JarFile(inputJar.toFile()));
            this.server.launcherBinary.coreLibs.forEach(e -> {
                try {
                    this.reader.getCp().add(new JarFile(e.toFile()));
                }
                catch (IOException e1) {
                    LogHelper.error((Throwable)e1);
                }
            });
            String zPath = launcherConfigurator.getZipEntryPath();
            Throwable throwable = null;
            try (ZipInputStream input = new ZipInputStream(IOHelper.newInput((Path)inputJar));){
                ZipEntry e2 = input.getNextEntry();
                while (e2 != null) {
                    String filename = e2.getName();
                    if (this.server.buildHookManager.isContainsBlacklist(filename) || e2.isDirectory() || zPath.equals(filename)) {
                        e2 = input.getNextEntry();
                        continue;
                    }
                    try {
                        output.putNextEntry(IOHelper.newZipEntry((ZipEntry)e2));
                    }
                    catch (ZipException ex) {
                        LogHelper.error((Throwable)ex);
                        e2 = input.getNextEntry();
                        continue;
                    }
                    if (filename.endsWith(".class")) {
                        byte[] bytes;
                        String classname = filename.replace('/', '.').substring(0, filename.length() - ".class".length());
                        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(2048);){
                            IOHelper.transfer((InputStream)input, (OutputStream)outputStream);
                            bytes = outputStream.toByteArray();
                        }
                        bytes = this.server.buildHookManager.classTransform(bytes, classname, this);
                        output.write(bytes);
                    } else {
                        IOHelper.transfer((InputStream)input, (OutputStream)output);
                    }
                    context.fileList.add(filename);
                    e2 = input.getNextEntry();
                }
            }
            catch (Throwable e2) {
                Throwable throwable2 = e2;
                throw e2;
            }
            for (Map.Entry entry : this.server.buildHookManager.getIncludeClass().entrySet()) {
                output.putNextEntry(IOHelper.newZipEntry((String)((String)entry.getKey()).replace('.', '/').concat(".class")));
                output.write(this.server.buildHookManager.classTransform((byte[])entry.getValue(), (String)entry.getKey(), this));
            }
            HashMap runtime = new HashMap(256);
            if (this.server.buildHookManager.buildRuntime()) {
                IOHelper.walk((Path)this.server.launcherBinary.runtimeDir, (FileVisitor)new RuntimeDirVisitor(output, runtime), (boolean)false);
                IOHelper.walk((Path)this.server.launcherBinary.guardDir, (FileVisitor)new GuardDirVisitor(output, runtime), (boolean)false);
            }
            try (ByteArrayOutputStream configArray = IOHelper.newByteArrayOutput();){
                try (HOutput configOutput = new HOutput((OutputStream)configArray);){
                    new LauncherConfig(this.server.config.netty.address, this.server.publicKey, runtime).write(configOutput);
                }
                byArray = configArray.toByteArray();
            }
            output.putNextEntry(IOHelper.newZipEntry((String)"config.bin"));
            output.write(byArray);
            ZipEntry e2 = IOHelper.newZipEntry((String)zPath);
            output.putNextEntry(e2);
            output.write(launcherConfigurator.getBytecode(this.reader));
        }
        this.reader.close();
        return outputJar;
    }

    @Override
    public boolean allowDelete() {
        return true;
    }

    private final class GuardDirVisitor
    extends SimpleFileVisitor<Path> {
        private final ZipOutputStream output;
        private final Map<String, byte[]> guard;

        private GuardDirVisitor(ZipOutputStream output, Map<String, byte[]> guard) {
            this.output = output;
            this.guard = guard;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            String dirName = IOHelper.toString((Path)((MainBuildTask)MainBuildTask.this).server.launcherBinary.guardDir.relativize(dir));
            this.output.putNextEntry(MainBuildTask.newGuardEntry(dirName + '/'));
            return super.preVisitDirectory(dir, attrs);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            String fileName = IOHelper.toString((Path)((MainBuildTask)MainBuildTask.this).server.launcherBinary.guardDir.relativize(file));
            this.guard.put(fileName, SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.MD5, (Path)file));
            this.output.putNextEntry(MainBuildTask.newGuardEntry(fileName));
            IOHelper.transfer((Path)file, (OutputStream)this.output);
            return super.visitFile(file, attrs);
        }
    }

    private final class RuntimeDirVisitor
    extends SimpleFileVisitor<Path> {
        private final ZipOutputStream output;
        private final Map<String, byte[]> runtime;

        private RuntimeDirVisitor(ZipOutputStream output, Map<String, byte[]> runtime) {
            this.output = output;
            this.runtime = runtime;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            String dirName = IOHelper.toString((Path)((MainBuildTask)MainBuildTask.this).server.launcherBinary.runtimeDir.relativize(dir));
            this.output.putNextEntry(MainBuildTask.newEntry(dirName + '/'));
            return super.preVisitDirectory(dir, attrs);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            String fileName = IOHelper.toString((Path)((MainBuildTask)MainBuildTask.this).server.launcherBinary.runtimeDir.relativize(file));
            this.runtime.put(fileName, SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.MD5, (Path)file));
            this.output.putNextEntry(MainBuildTask.newEntry(fileName));
            IOHelper.transfer((Path)file, (OutputStream)this.output);
            return super.visitFile(file, attrs);
        }
    }
}

