/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.service;

import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.utils.helper.LogHelper;

public class GivePermissionsCommand
extends Command {
    public GivePermissionsCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[username] [permission] [true/false]";
    }

    public String getUsageDescription() {
        return "give permissions";
    }

    public void invoke(String ... args) throws Exception {
        this.verifyArgs(args, 3);
        String username = args[0];
        ClientPermissions permissions = this.server.config.permissionsHandler.getPermissions(username);
        String permission = args[1];
        boolean isEnabled = Boolean.valueOf(args[2]);
        switch (permission) {
            case "admin": {
                permissions.canAdmin = isEnabled;
                break;
            }
            case "server": {
                permissions.canServer = isEnabled;
                break;
            }
            case "bot": {
                permissions.canBot = isEnabled;
                break;
            }
            default: {
                LogHelper.error((String)"Unknown permission: %s", (Object[])new Object[]{permission});
                return;
            }
        }
        LogHelper.info((String)"Write new permissions for %s", (Object[])new Object[]{username});
        this.server.config.permissionsHandler.setPermissions(username, permissions);
    }
}

