/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.dao.provider;

import java.nio.file.Paths;
import org.hibernate.cfg.Configuration;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.dao.User;
import pro.gravit.launchserver.dao.UserHWID;
import pro.gravit.launchserver.dao.UserService;
import pro.gravit.launchserver.dao.impl.HibernateUserDAOImpl;
import pro.gravit.launchserver.dao.provider.DaoProvider;
import pro.gravit.utils.helper.CommonHelper;

public class HibernateDaoProvider
extends DaoProvider {
    public String driver;
    public String url;
    public String username;
    public String password;
    public String dialect;
    public String pool_size;
    public String hibernateConfig;
    public boolean parallelHibernateInit;

    @Override
    public void init(LaunchServer server) {
        Runnable init = () -> {
            Configuration cfg = new Configuration().addAnnotatedClass(User.class).addAnnotatedClass(UserHWID.class).setProperty("hibernate.connection.driver_class", this.driver).setProperty("hibernate.connection.url", this.url).setProperty("hibernate.connection.username", this.username).setProperty("hibernate.connection.password", this.password).setProperty("hibernate.connection.pool_size", this.pool_size);
            if (this.dialect != null) {
                cfg.setProperty("hibernate.dialect", this.dialect);
            }
            if (this.hibernateConfig != null) {
                cfg.configure(Paths.get(this.hibernateConfig, new String[0]).toFile());
            }
            this.userDAO = new HibernateUserDAOImpl(cfg.buildSessionFactory());
            this.userService = new UserService(this.userDAO);
        };
        if (this.parallelHibernateInit) {
            CommonHelper.newThread((String)"Hibernate Thread", (boolean)true, (Runnable)init);
        } else {
            init.run();
        }
    }
}

