/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.auth;

import io.netty.channel.ChannelHandlerContext;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.SetPasswordRequestEvent;
import pro.gravit.launchserver.dao.User;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;

public class SetPasswordResponse
extends SimpleResponse {
    public String oldPassword;
    public String newPassword;
    public String username;

    @Override
    public String getType() {
        return "setPassword";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) throws Exception {
        if (this.oldPassword == null && this.username == null || this.newPassword == null) {
            this.sendError("Request invalid");
            return;
        }
        if (!client.isAuth) {
            this.sendError("You not authorized");
            return;
        }
        if (this.username != null && !client.permissions.canAdmin) {
            this.sendError("You not admin");
            return;
        }
        if (this.username != null) {
            User user = this.server.config.dao.userService.findUserByUsername(this.username);
            user.setPassword(this.newPassword);
            this.sendResult((RequestEvent)new SetPasswordRequestEvent());
        } else {
            User user = this.server.config.dao.userService.findUserByUsername(client.username);
            if (user.verifyPassword(this.oldPassword)) {
                user.setPassword(this.newPassword);
                this.sendResult((RequestEvent)new SetPasswordRequestEvent());
            } else {
                this.sendError("Old password incorrect");
            }
        }
    }
}

