/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver;

import io.netty.channel.epoll.Epoll;
import io.netty.handler.logging.LogLevel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.CRC32;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.operator.OperatorCreationException;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.NeedGarbageCollection;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.hwid.HWIDProvider;
import pro.gravit.launcher.managers.ConfigManager;
import pro.gravit.launcher.managers.GarbageManager;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launchserver.Reconfigurable;
import pro.gravit.launchserver.Reloadable;
import pro.gravit.launchserver.StarterAgent;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.handler.AuthHandler;
import pro.gravit.launchserver.auth.handler.MemoryAuthHandler;
import pro.gravit.launchserver.auth.hwid.AcceptHWIDHandler;
import pro.gravit.launchserver.auth.hwid.HWIDHandler;
import pro.gravit.launchserver.auth.permissions.DefaultPermissionsHandler;
import pro.gravit.launchserver.auth.permissions.JsonFilePermissionsHandler;
import pro.gravit.launchserver.auth.permissions.PermissionsHandler;
import pro.gravit.launchserver.auth.protect.ProtectHandler;
import pro.gravit.launchserver.auth.protect.StdProtectHandler;
import pro.gravit.launchserver.auth.provider.AuthProvider;
import pro.gravit.launchserver.auth.provider.RejectAuthProvider;
import pro.gravit.launchserver.auth.texture.RequestTextureProvider;
import pro.gravit.launchserver.auth.texture.TextureProvider;
import pro.gravit.launchserver.binary.EXEL4JLauncherBinary;
import pro.gravit.launchserver.binary.EXELauncherBinary;
import pro.gravit.launchserver.binary.JARLauncherBinary;
import pro.gravit.launchserver.binary.LauncherBinary;
import pro.gravit.launchserver.binary.ProguardConf;
import pro.gravit.launchserver.binary.SimpleEXELauncherBinary;
import pro.gravit.launchserver.command.handler.CommandHandler;
import pro.gravit.launchserver.components.AuthLimiterComponent;
import pro.gravit.launchserver.components.Component;
import pro.gravit.launchserver.components.RegLimiterComponent;
import pro.gravit.launchserver.config.LaunchServerRuntimeConfig;
import pro.gravit.launchserver.dao.provider.DaoProvider;
import pro.gravit.launchserver.manangers.CertificateManager;
import pro.gravit.launchserver.manangers.LaunchServerGsonManager;
import pro.gravit.launchserver.manangers.MirrorManager;
import pro.gravit.launchserver.manangers.ModulesManager;
import pro.gravit.launchserver.manangers.ReconfigurableManager;
import pro.gravit.launchserver.manangers.ReloadManager;
import pro.gravit.launchserver.manangers.SessionManager;
import pro.gravit.launchserver.manangers.hook.AuthHookManager;
import pro.gravit.launchserver.manangers.hook.BuildHookManager;
import pro.gravit.launchserver.socket.WebSocketService;
import pro.gravit.launchserver.socket.handlers.NettyServerSocketHandler;
import pro.gravit.utils.Version;
import pro.gravit.utils.command.JLineCommandHandler;
import pro.gravit.utils.command.StdCommandHandler;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public final class LaunchServer
implements Runnable,
AutoCloseable,
Reloadable {
    public final Path dir;
    public final boolean testEnv;
    public final Path launcherLibraries;
    public final Path launcherLibrariesCompile;
    public final List<String> args;
    public final Path configFile;
    public final Path runtimeConfigFile;
    public final Path publicKeyFile;
    public final Path privateKeyFile;
    public final Path caCertFile;
    public final Path caKeyFile;
    public final Path serverCertFile;
    public final Path serverKeyFile;
    public final Path updatesDir;
    public final Path profilesDir;
    public Config config;
    public LaunchServerRuntimeConfig runtime;
    public final RSAPublicKey publicKey;
    public final RSAPrivateKey privateKey;
    public final JARLauncherBinary launcherBinary;
    public Class<? extends LauncherBinary> launcherEXEBinaryClass;
    public final LauncherBinary launcherEXEBinary;
    public final SessionManager sessionManager;
    public final AuthHookManager authHookManager;
    public final ModulesManager modulesManager;
    public final MirrorManager mirrorManager;
    public final ReloadManager reloadManager;
    public final ReconfigurableManager reconfigurableManager;
    public final ConfigManager configManager;
    public final CertificateManager certificateManager;
    public final BuildHookManager buildHookManager;
    public final ProguardConf proguardConf;
    public final pro.gravit.utils.command.CommandHandler commandHandler;
    public final NettyServerSocketHandler nettyServerSocketHandler;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private volatile List<ClientProfile> profilesList;
    public volatile Map<String, HashedDir> updatesDirMap;
    public final Timer taskPool;
    public static Class<? extends LauncherBinary> defaultLauncherEXEBinaryClass = null;

    @Override
    public void reload() throws Exception {
        this.config.close();
        LogHelper.info((String)"Reading LaunchServer config file");
        try (BufferedReader reader = IOHelper.newReader((Path)this.configFile);){
            this.config = (Config)Launcher.gsonManager.gson.fromJson((Reader)reader, Config.class);
        }
        this.config.server = this;
        this.config.verify();
        this.config.init();
    }

    public static void main(String ... args) throws Throwable {
        JVMHelper.checkStackTrace(LaunchServer.class);
        JVMHelper.verifySystemProperties(LaunchServer.class, (boolean)true);
        LogHelper.addOutput((Path)IOHelper.WORKING_DIR.resolve("LaunchServer.log"));
        LogHelper.printVersion((String)"LaunchServer");
        LogHelper.printLicense((String)"LaunchServer");
        if (!StarterAgent.isAgentStarted()) {
            LogHelper.error((String)"StarterAgent is not started!");
            LogHelper.error((String)"You should add to JVM options this option: `-javaagent:LaunchServer.jar`");
        }
        long startTime = System.currentTimeMillis();
        try {
            LaunchServer launchserver = new LaunchServer(IOHelper.WORKING_DIR, false, args);
            if (args.length == 0) {
                launchserver.run();
            } else {
                launchserver.commandHandler.eval(args, false);
            }
        }
        catch (Throwable exc) {
            LogHelper.error((Throwable)exc);
            return;
        }
        long endTime = System.currentTimeMillis();
        LogHelper.debug((String)"LaunchServer started in %dms", (Object[])new Object[]{endTime - startTime});
    }

    public LaunchServer(Path dir, boolean testEnv, String[] args) throws IOException, InvalidKeySpecException {
        StdCommandHandler localCommandHandler;
        this.dir = dir;
        this.testEnv = testEnv;
        this.taskPool = new Timer("Timered task worker thread", true);
        this.launcherLibraries = dir.resolve("launcher-libraries");
        this.launcherLibrariesCompile = dir.resolve("launcher-libraries-compile");
        this.args = Arrays.asList(args);
        this.configFile = IOHelper.exists((Path)dir.resolve("LaunchServer.conf")) ? dir.resolve("LaunchServer.conf") : dir.resolve("LaunchServer.json");
        this.runtimeConfigFile = IOHelper.exists((Path)dir.resolve("RuntimeLaunchServer.conf")) ? dir.resolve("RuntimeLaunchServer.conf") : dir.resolve("RuntimeLaunchServer.json");
        this.publicKeyFile = dir.resolve("public.key");
        this.privateKeyFile = dir.resolve("private.key");
        this.updatesDir = dir.resolve("updates");
        this.profilesDir = dir.resolve("profiles");
        this.caCertFile = dir.resolve("ca.crt");
        this.caKeyFile = dir.resolve("ca.key");
        this.serverCertFile = dir.resolve("server.crt");
        this.serverKeyFile = dir.resolve("server.key");
        AuthHandler.registerHandlers();
        AuthProvider.registerProviders();
        TextureProvider.registerProviders();
        HWIDHandler.registerHandlers();
        PermissionsHandler.registerHandlers();
        Component.registerComponents();
        ProtectHandler.registerHandlers();
        WebSocketService.registerResponses();
        HWIDProvider.registerHWIDs();
        DaoProvider.registerProviders();
        if (testEnv) {
            localCommandHandler = new StdCommandHandler(false);
        } else {
            try {
                Class.forName("org.jline.terminal.Terminal");
                localCommandHandler = new JLineCommandHandler();
                LogHelper.info((String)"JLine2 terminal enabled");
            }
            catch (ClassNotFoundException ignored) {
                localCommandHandler = new StdCommandHandler(true);
                LogHelper.warning((String)"JLine2 isn't in classpath, using std");
            }
        }
        this.commandHandler = localCommandHandler;
        if (IOHelper.isFile((Path)this.publicKeyFile) && IOHelper.isFile((Path)this.privateKeyFile)) {
            LogHelper.info((String)"Reading RSA keypair");
            this.publicKey = SecurityHelper.toPublicRSAKey((byte[])IOHelper.read((Path)this.publicKeyFile));
            this.privateKey = SecurityHelper.toPrivateRSAKey((byte[])IOHelper.read((Path)this.privateKeyFile));
            if (!this.publicKey.getModulus().equals(this.privateKey.getModulus())) {
                throw new IOException("Private and public key modulus mismatch");
            }
        } else {
            LogHelper.info((String)"Generating RSA keypair");
            KeyPair pair = SecurityHelper.genRSAKeyPair();
            this.publicKey = (RSAPublicKey)pair.getPublic();
            this.privateKey = (RSAPrivateKey)pair.getPrivate();
            LogHelper.info((String)"Writing RSA keypair list");
            IOHelper.write((Path)this.publicKeyFile, (byte[])this.publicKey.getEncoded());
            IOHelper.write((Path)this.privateKeyFile, (byte[])this.privateKey.getEncoded());
        }
        CRC32 crc = new CRC32();
        crc.update(this.publicKey.getModulus().toByteArray());
        LogHelper.subInfo((String)"Modulus CRC32: 0x%08x", (Object[])new Object[]{crc.getValue()});
        this.launcherEXEBinaryClass = defaultLauncherEXEBinaryClass;
        this.modulesManager = new ModulesManager(this);
        this.modulesManager.autoload(dir.resolve("modules"));
        this.modulesManager.preInitModules();
        LaunchServer.initGson();
        this.generateConfigIfNotExists(testEnv);
        LogHelper.info((String)"Reading LaunchServer config file");
        try (AuthProviderPair[] reader = IOHelper.newReader((Path)this.configFile);){
            this.config = (Config)Launcher.gsonManager.gson.fromJson((Reader)reader, Config.class);
        }
        this.config.server = this;
        if (!Files.exists(this.runtimeConfigFile, new LinkOption[0])) {
            LogHelper.info((String)"Reset LaunchServer runtime config file");
            this.runtime = new LaunchServerRuntimeConfig();
            this.runtime.reset();
        } else {
            LogHelper.info((String)"Reading LaunchServer runtime config file");
            reader = IOHelper.newReader((Path)this.runtimeConfigFile);
            var7_11 = null;
            try {
                this.runtime = (LaunchServerRuntimeConfig)Launcher.gsonManager.gson.fromJson((Reader)reader, LaunchServerRuntimeConfig.class);
            }
            catch (Throwable throwable) {
                var7_11 = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (var7_11 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            var7_11.addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        this.runtime.verify();
        this.config.verify();
        Launcher.applyLauncherEnv((LauncherConfig.LauncherEnvironment)this.config.env);
        for (AuthProviderPair provider : this.config.auth) {
            provider.init(this);
        }
        this.config.permissionsHandler.init(this);
        this.config.hwidHandler.init();
        if (this.config.dao != null) {
            this.config.dao.init(this);
        }
        if (this.config.protectHandler != null) {
            this.config.protectHandler.checkLaunchServerLicense();
        }
        if (this.config.components != null) {
            LogHelper.debug((String)"PreInit components");
            this.config.components.forEach((k, v) -> {
                LogHelper.subDebug((String)"PreInit component %s", (Object[])new Object[]{k});
                v.preInit(this);
            });
            LogHelper.debug((String)"PreInit components successful");
        }
        this.buildHookManager = new BuildHookManager();
        this.proguardConf = new ProguardConf(this);
        this.sessionManager = new SessionManager();
        this.mirrorManager = new MirrorManager();
        this.reloadManager = new ReloadManager();
        this.reconfigurableManager = new ReconfigurableManager();
        this.authHookManager = new AuthHookManager();
        this.configManager = new ConfigManager();
        this.certificateManager = new CertificateManager();
        this.certificateManager.orgName = this.config.projectName;
        if (this.config.certificate != null && this.config.certificate.enabled) {
            if (IOHelper.isFile((Path)this.caCertFile) && IOHelper.isFile((Path)this.caKeyFile)) {
                this.certificateManager.ca = this.certificateManager.readCertificate(this.caCertFile);
                this.certificateManager.caKey = this.certificateManager.readPrivateKey(this.caKeyFile);
            } else {
                try {
                    this.certificateManager.generateCA();
                    this.certificateManager.writeCertificate(this.caCertFile, this.certificateManager.ca);
                    this.certificateManager.writePrivateKey(this.caKeyFile, this.certificateManager.caKey);
                }
                catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | OperatorCreationException e) {
                    LogHelper.error((Throwable)e);
                }
            }
            if (IOHelper.isFile((Path)this.serverCertFile) && IOHelper.isFile((Path)this.serverKeyFile)) {
                this.certificateManager.server = this.certificateManager.readCertificate(this.serverCertFile);
                this.certificateManager.serverKey = this.certificateManager.readPrivateKey(this.serverKeyFile);
            } else {
                try {
                    KeyPair pair = this.certificateManager.generateKeyPair();
                    this.certificateManager.server = this.certificateManager.generateCertificate(this.config.projectName.concat(" Server"), pair.getPublic());
                    this.certificateManager.serverKey = PrivateKeyFactory.createKey((byte[])pair.getPrivate().getEncoded());
                    this.certificateManager.writePrivateKey(this.serverKeyFile, pair.getPrivate());
                    this.certificateManager.writeCertificate(this.serverCertFile, this.certificateManager.server);
                }
                catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | OperatorCreationException e) {
                    LogHelper.error((Throwable)e);
                }
            }
        }
        GarbageManager.registerNeedGC((NeedGarbageCollection)this.sessionManager);
        this.reloadManager.registerReloadable("launchServer", this);
        this.registerObject("permissionsHandler", this.config.permissionsHandler);
        for (int i = 0; i < this.config.auth.length; ++i) {
            AuthProviderPair pair = this.config.auth[i];
            this.registerObject("auth.".concat(pair.name).concat(".provider"), pair.provider);
            this.registerObject("auth.".concat(pair.name).concat(".handler"), pair.handler);
            this.registerObject("auth.".concat(pair.name).concat(".texture"), pair.textureProvider);
        }
        Arrays.stream(this.config.mirrors).forEach(this.mirrorManager::addMirror);
        CommandHandler.registerCommands((pro.gravit.utils.command.CommandHandler)localCommandHandler, this);
        this.modulesManager.initModules();
        if (this.config.components != null) {
            LogHelper.debug((String)"Init components");
            this.config.components.forEach((k, v) -> {
                LogHelper.subDebug((String)"Init component %s", (Object[])new Object[]{k});
                this.registerObject("component.".concat((String)k), v);
                v.init(this);
            });
            LogHelper.debug((String)"Init components successful");
        }
        this.launcherBinary = new JARLauncherBinary(this);
        this.launcherEXEBinary = this.binary();
        this.launcherBinary.init();
        this.launcherEXEBinary.init();
        this.syncLauncherBinaries();
        if (!IOHelper.isDir((Path)this.updatesDir)) {
            Files.createDirectory(this.updatesDir, new FileAttribute[0]);
        }
        this.syncUpdatesDir(null);
        if (!IOHelper.isDir((Path)this.profilesDir)) {
            Files.createDirectory(this.profilesDir, new FileAttribute[0]);
        }
        this.syncProfilesDir();
        this.modulesManager.postInitModules();
        if (this.config.components != null) {
            LogHelper.debug((String)"PostInit components");
            this.config.components.forEach((k, v) -> {
                LogHelper.subDebug((String)"PostInit component %s", (Object[])new Object[]{k});
                v.postInit(this);
            });
            LogHelper.debug((String)"PostInit components successful");
        }
        this.nettyServerSocketHandler = this.config.netty != null ? new NettyServerSocketHandler(this) : null;
    }

    public static void initGson() {
        Launcher.gsonManager = new LaunchServerGsonManager();
        Launcher.gsonManager.initGson();
    }

    private LauncherBinary binary() {
        if (this.launcherEXEBinaryClass != null) {
            try {
                return this.launcherEXEBinaryClass.getConstructor(LaunchServer.class).newInstance(this);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LogHelper.error((Throwable)e);
            }
        }
        if (this.config.launch4j.alternative != null) {
            switch (this.config.launch4j.alternative) {
                case "simple": {
                    return new SimpleEXELauncherBinary(this);
                }
                case "no": {
                    break;
                }
                default: {
                    LogHelper.warning((String)"Alternative %s not found", (Object[])new Object[]{this.config.launch4j.alternative});
                }
            }
        }
        try {
            Class.forName("net.sf.launch4j.Builder");
            if (this.config.launch4j.enabled) {
                return new EXEL4JLauncherBinary(this);
            }
        }
        catch (ClassNotFoundException ignored) {
            LogHelper.warning((String)"Launch4J isn't in classpath.");
        }
        return new EXELauncherBinary(this);
    }

    public void buildLauncherBinaries() throws IOException {
        this.launcherBinary.build();
        this.launcherEXEBinary.build();
    }

    @Override
    public void close() {
        this.config.close();
        this.modulesManager.close();
        LogHelper.info((String)"Save LaunchServer runtime config");
        try (BufferedWriter writer = IOHelper.newWriter((Path)this.runtimeConfigFile);){
            if (Launcher.gsonManager.configGson != null) {
                Launcher.gsonManager.configGson.toJson((Object)this.runtime, (Appendable)writer);
            } else {
                LogHelper.error((String)"Error writing LaunchServer runtime config file. Gson is null");
            }
        }
        catch (IOException e) {
            LogHelper.error((Throwable)e);
        }
        LogHelper.info((String)"LaunchServer stopped");
    }

    private void generateConfigIfNotExists(boolean testEnv) throws IOException {
        String address;
        if (IOHelper.isFile((Path)this.configFile)) {
            return;
        }
        LogHelper.info((String)"Creating LaunchServer config");
        Config newConfig = new Config();
        newConfig.mirrors = new String[]{"https://mirror.gravit.pro/"};
        newConfig.launch4j = new ExeConf();
        newConfig.launch4j.enabled = true;
        newConfig.launch4j.copyright = "\u00a9 GravitLauncher Team";
        newConfig.launch4j.alternative = "no";
        newConfig.launch4j.fileDesc = "GravitLauncher ".concat(Version.getVersion().getVersionString());
        newConfig.launch4j.fileVer = Version.getVersion().getVersionString().concat(".").concat(String.valueOf(Version.getVersion().patch));
        newConfig.launch4j.internalName = "Launcher";
        newConfig.launch4j.trademarks = "This product is licensed under GPLv3";
        newConfig.launch4j.txtFileVersion = "%s, build %d";
        newConfig.launch4j.txtProductVersion = "%s, build %d";
        newConfig.launch4j.productName = "GravitLauncher";
        newConfig.launch4j.productVer = newConfig.launch4j.fileVer;
        newConfig.launch4j.maxVersion = "1.8.999";
        newConfig.env = LauncherConfig.LauncherEnvironment.STD;
        newConfig.startScript = JVMHelper.OS_TYPE.equals((Object)JVMHelper.OS.MUSTDIE) ? "." + File.separator + "start.bat" : "." + File.separator + "start.sh";
        newConfig.hwidHandler = new AcceptHWIDHandler();
        newConfig.auth = new AuthProviderPair[]{new AuthProviderPair(new RejectAuthProvider("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u0442\u0435 authProvider"), new MemoryAuthHandler(), new RequestTextureProvider("http://example.com/skins/%username%.png", "http://example.com/cloaks/%username%.png"), "std")};
        newConfig.auth[0].displayName = "Default";
        newConfig.protectHandler = new StdProtectHandler();
        newConfig.permissionsHandler = testEnv ? new DefaultPermissionsHandler() : new JsonFilePermissionsHandler();
        newConfig.binaryName = "Launcher";
        newConfig.whitelistRejectString = "\u0412\u0430\u0441 \u043d\u0435\u0442 \u0432 \u0431\u0435\u043b\u043e\u043c \u0441\u043f\u0438\u0441\u043a\u0435";
        newConfig.netty = new NettyConfig();
        newConfig.netty.fileServerEnabled = true;
        newConfig.netty.binds = new NettyBindAddress[]{new NettyBindAddress("0.0.0.0", 9274)};
        newConfig.netty.performance = new NettyPerformanceConfig();
        newConfig.netty.performance.usingEpoll = Epoll.isAvailable();
        newConfig.netty.performance.bossThread = 2;
        newConfig.netty.performance.workerThread = 8;
        newConfig.launcher = new LauncherConf();
        newConfig.launcher.guardType = "no";
        newConfig.launcher.compress = true;
        newConfig.launcher.warningMissArchJava = true;
        newConfig.launcher.attachLibraryBeforeProGuard = false;
        newConfig.launcher.deleteTempFiles = true;
        newConfig.launcher.enabledProGuard = true;
        newConfig.launcher.stripLineNumbers = true;
        newConfig.launcher.proguardGenMappings = true;
        newConfig.certificate = new CertificateConf();
        newConfig.certificate.enabled = false;
        newConfig.components = new HashMap<String, Component>();
        AuthLimiterComponent authLimiterComponent = new AuthLimiterComponent();
        authLimiterComponent.rateLimit = 3;
        authLimiterComponent.rateLimitMilis = 8000;
        authLimiterComponent.message = "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043b\u0438\u043c\u0438\u0442 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0439";
        newConfig.components.put("authLimiter", authLimiterComponent);
        RegLimiterComponent regLimiterComponent = new RegLimiterComponent();
        regLimiterComponent.rateLimit = 3;
        regLimiterComponent.rateLimitMilis = 36000000;
        regLimiterComponent.message = "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043b\u0438\u043c\u0438\u0442 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0439";
        newConfig.components.put("regLimiter", regLimiterComponent);
        if (testEnv) {
            address = "localhost";
            newConfig.setProjectName("test");
        } else {
            System.out.println("LaunchServer address(default: localhost): ");
            address = this.commandHandler.readLine();
            System.out.println("LaunchServer projectName: ");
            newConfig.setProjectName(this.commandHandler.readLine());
        }
        if (address == null || address.isEmpty()) {
            LogHelper.error((String)"Address null. Using localhost");
            address = "localhost";
        }
        if (newConfig.projectName == null || newConfig.projectName.isEmpty()) {
            LogHelper.error((String)"ProjectName null. Using MineCraft");
            newConfig.projectName = "MineCraft";
        }
        newConfig.netty.address = "ws://" + address + ":9274/api";
        newConfig.netty.downloadURL = "http://" + address + ":9274/%dirname%/";
        newConfig.netty.launcherURL = "http://" + address + ":9274/Launcher.jar";
        newConfig.netty.launcherEXEURL = "http://" + address + ":9274/Launcher.exe";
        newConfig.netty.sendExceptionEnabled = true;
        LogHelper.info((String)"Writing LaunchServer config file");
        try (BufferedWriter writer = IOHelper.newWriter((Path)this.configFile);){
            Launcher.gsonManager.configGson.toJson((Object)newConfig, (Appendable)writer);
        }
    }

    public List<ClientProfile> getProfiles() {
        return this.profilesList;
    }

    public void setProfiles(List<ClientProfile> profilesList) {
        this.profilesList = Collections.unmodifiableList(profilesList);
    }

    public HashedDir getUpdateDir(String name) {
        return this.updatesDirMap.get(name);
    }

    public Set<Map.Entry<String, HashedDir>> getUpdateDirs() {
        return this.updatesDirMap.entrySet();
    }

    public void rebindNettyServerSocket() {
        this.nettyServerSocketHandler.close();
        CommonHelper.newThread((String)"Netty Server Socket Thread", (boolean)false, (Runnable)this.nettyServerSocketHandler).start();
    }

    @Override
    public void run() {
        if (this.started.getAndSet(true)) {
            throw new IllegalStateException("LaunchServer has been already started");
        }
        if (!this.testEnv) {
            JVMHelper.RUNTIME.addShutdownHook(CommonHelper.newThread(null, (boolean)false, this::close));
            CommonHelper.newThread((String)"Command Thread", (boolean)true, (Runnable)this.commandHandler).start();
        }
        if (this.config.netty != null) {
            this.rebindNettyServerSocket();
        }
        this.modulesManager.finishModules();
    }

    public void syncLauncherBinaries() throws IOException {
        LogHelper.info((String)"Syncing launcher binaries");
        LogHelper.info((String)"Syncing launcher binary file");
        if (!this.launcherBinary.sync()) {
            LogHelper.warning((String)"Missing launcher binary file");
        }
        LogHelper.info((String)"Syncing launcher EXE binary file");
        if (!this.launcherEXEBinary.sync() && this.config.launch4j.enabled) {
            LogHelper.warning((String)"Missing launcher EXE binary file");
        }
    }

    public void syncProfilesDir() throws IOException {
        LogHelper.info((String)"Syncing profiles dir");
        LinkedList<ClientProfile> newProfies = new LinkedList<ClientProfile>();
        IOHelper.walk((Path)this.profilesDir, (FileVisitor)new ProfilesFileVisitor(newProfies), (boolean)false);
        newProfies.sort(Comparator.comparing(a -> a));
        this.profilesList = Collections.unmodifiableList(newProfies);
    }

    public void syncUpdatesDir(Collection<String> dirs) throws IOException {
        LogHelper.info((String)"Syncing updates dir");
        HashMap<String, HashedDir> newUpdatesDirMap = new HashMap<String, HashedDir>(16);
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(this.updatesDir);){
            for (Path updateDir : dirStream) {
                HashedDir hdir;
                if (Files.isHidden(updateDir)) continue;
                String name = IOHelper.getFileName((Path)updateDir);
                if (!IOHelper.isDir((Path)updateDir)) {
                    if (IOHelper.isFile((Path)updateDir) || !Arrays.asList(".jar", ".exe", ".hash").stream().noneMatch(e -> updateDir.toString().endsWith((String)e))) continue;
                    LogHelper.warning((String)"Not update dir: '%s'", (Object[])new Object[]{name});
                    continue;
                }
                if (dirs != null && !dirs.contains(name) && (hdir = this.updatesDirMap.get(name)) != null) {
                    newUpdatesDirMap.put(name, hdir);
                    continue;
                }
                LogHelper.info((String)"Syncing '%s' update dir", (Object[])new Object[]{name});
                HashedDir updateHDir = new HashedDir(updateDir, null, true, true);
                newUpdatesDirMap.put(name, updateHDir);
            }
        }
        this.updatesDirMap = Collections.unmodifiableMap(newUpdatesDirMap);
    }

    public void restart() {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        if (this.config.startScript == null) {
            throw new IllegalArgumentException("Please create start script and link it as startScript in config.");
        }
        builder.command(Collections.singletonList(this.config.startScript));
        builder.directory(this.dir.toFile());
        builder.inheritIO();
        builder.redirectErrorStream(true);
        builder.redirectOutput(ProcessBuilder.Redirect.PIPE);
        try {
            builder.start();
        }
        catch (IOException e) {
            LogHelper.error((Throwable)e);
        }
    }

    public void registerObject(String name, Object object) {
        if (object instanceof Reloadable) {
            this.reloadManager.registerReloadable(name, (Reloadable)object);
        }
        if (object instanceof Reconfigurable) {
            this.reconfigurableManager.registerReconfigurable(name, (Reconfigurable)object);
        }
        if (object instanceof NeedGarbageCollection) {
            GarbageManager.registerNeedGC((NeedGarbageCollection)((NeedGarbageCollection)object));
        }
    }

    public void unregisterObject(String name, Object object) {
        if (object instanceof Reloadable) {
            this.reloadManager.unregisterReloadable(name);
        }
        if (object instanceof Reconfigurable) {
            this.reconfigurableManager.unregisterReconfigurable(name);
        }
        if (object instanceof NeedGarbageCollection) {
            GarbageManager.unregisterNeedGC((NeedGarbageCollection)((NeedGarbageCollection)object));
        }
    }

    public void fullyRestart() {
        this.restart();
        JVMHelper.RUNTIME.exit(0);
    }

    private final class ProfilesFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Collection<ClientProfile> result;

        private ProfilesFileVisitor(Collection<ClientProfile> result) {
            this.result = result;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            ClientProfile profile;
            LogHelper.info((String)"Syncing '%s' profile", (Object[])new Object[]{IOHelper.getFileName((Path)file)});
            try (BufferedReader reader = IOHelper.newReader((Path)file);){
                profile = (ClientProfile)Launcher.gsonManager.gson.fromJson((Reader)reader, ClientProfile.class);
            }
            profile.verify();
            this.result.add(profile);
            return super.visitFile(file, attrs);
        }
    }

    public class GuardLicenseConf {
        public String name;
        public String key;
        public String encryptKey;
    }

    public class NettyBindAddress {
        public String address;
        public int port;

        public NettyBindAddress(String address, int port) {
            this.address = address;
            this.port = port;
        }
    }

    public class NettyPerformanceConfig {
        public boolean usingEpoll;
        public int bossThread;
        public int workerThread;
    }

    public class NettyConfig {
        public boolean fileServerEnabled;
        public boolean sendExceptionEnabled;
        public boolean ipForwarding;
        public String launcherURL;
        public String downloadURL;
        public String launcherEXEURL;
        public String address;
        public Map<String, NettyUpdatesBind> bindings = new HashMap<String, NettyUpdatesBind>();
        public NettyPerformanceConfig performance;
        public NettyBindAddress[] binds;
        public LogLevel logLevel = LogLevel.DEBUG;
    }

    public class LauncherConf {
        public String guardType;
        public boolean attachLibraryBeforeProGuard;
        public boolean compress;
        public boolean warningMissArchJava;
        public boolean enabledProGuard;
        public boolean stripLineNumbers;
        public boolean deleteTempFiles;
        public boolean proguardGenMappings;
    }

    public static class NettyUpdatesBind {
        public String url;
        public boolean zip;
    }

    public static class CertificateConf {
        public boolean enabled;
    }

    public static class ExeConf {
        public boolean enabled;
        public String alternative;
        public boolean setMaxVersion;
        public String maxVersion;
        public String productName;
        public String productVer;
        public String fileDesc;
        public String fileVer;
        public String internalName;
        public String copyright;
        public String trademarks;
        public String txtFileVersion;
        public String txtProductVersion;
    }

    public static final class Config {
        private transient LaunchServer server = null;
        public String projectName;
        public String[] mirrors;
        public String binaryName;
        public boolean copyBinaries = true;
        public LauncherConfig.LauncherEnvironment env;
        public AuthProviderPair[] auth;
        public DaoProvider dao;
        private transient AuthProviderPair authDefault;
        public ProtectHandler protectHandler;
        public PermissionsHandler permissionsHandler;
        public HWIDHandler hwidHandler;
        public Map<String, Component> components;
        public ExeConf launch4j;
        public NettyConfig netty;
        public GuardLicenseConf guardLicense;
        public String whitelistRejectString;
        public LauncherConf launcher;
        public CertificateConf certificate;
        public String startScript;

        public AuthProviderPair getAuthProviderPair(String name) {
            for (AuthProviderPair pair : this.auth) {
                if (!pair.name.equals(name)) continue;
                return pair;
            }
            return null;
        }

        public AuthProviderPair getAuthProviderPair() {
            if (this.authDefault != null) {
                return this.authDefault;
            }
            for (AuthProviderPair pair : this.auth) {
                if (!pair.isDefault) continue;
                this.authDefault = pair;
                return pair;
            }
            return null;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public void setBinaryName(String binaryName) {
            this.binaryName = binaryName;
        }

        public void setEnv(LauncherConfig.LauncherEnvironment env) {
            this.env = env;
        }

        public void verify() {
            if (this.auth == null || this.auth[0] == null) {
                throw new NullPointerException("AuthHandler must not be null");
            }
            boolean isOneDefault = false;
            for (AuthProviderPair pair : this.auth) {
                if (!pair.isDefault) continue;
                isOneDefault = true;
                break;
            }
            if (this.protectHandler == null) {
                throw new NullPointerException("ProtectHandler must not be null");
            }
            if (!isOneDefault) {
                throw new IllegalStateException("No auth pairs declared by default.");
            }
            if (this.permissionsHandler == null) {
                throw new NullPointerException("PermissionsHandler must not be null");
            }
            if (this.env == null) {
                throw new NullPointerException("Env must not be null");
            }
            if (this.netty == null) {
                throw new NullPointerException("Netty must not be null");
            }
        }

        public void init() {
            Launcher.applyLauncherEnv((LauncherConfig.LauncherEnvironment)this.env);
            for (AuthProviderPair provider : this.auth) {
                provider.init(this.server);
            }
            this.permissionsHandler.init(this.server);
            this.hwidHandler.init();
            this.dao.init(this.server);
            if (this.protectHandler != null) {
                this.protectHandler.checkLaunchServerLicense();
            }
            this.server.registerObject("permissionsHandler", this.permissionsHandler);
            this.server.registerObject("daoProvider", this.dao);
            for (AuthProviderPair pair : this.auth) {
                this.server.registerObject("auth.".concat(pair.name).concat(".provider"), pair.provider);
                this.server.registerObject("auth.".concat(pair.name).concat(".handler"), pair.handler);
                this.server.registerObject("auth.".concat(pair.name).concat(".texture"), pair.textureProvider);
            }
            Arrays.stream(this.mirrors).forEach(this.server.mirrorManager::addMirror);
        }

        public void close() {
            try {
                this.server.unregisterObject("permissionsHandler", this.permissionsHandler);
                for (AuthProviderPair pair : this.auth) {
                    this.server.unregisterObject("auth.".concat(pair.name).concat(".provider"), pair.provider);
                    this.server.unregisterObject("auth.".concat(pair.name).concat(".handler"), pair.handler);
                    this.server.unregisterObject("auth.".concat(pair.name).concat(".texture"), pair.textureProvider);
                }
            }
            catch (Exception e) {
                LogHelper.error((Throwable)e);
            }
            try {
                for (AuthProviderPair p : this.auth) {
                    p.close();
                }
            }
            catch (IOException e) {
                LogHelper.error((Throwable)e);
            }
            try {
                this.hwidHandler.close();
            }
            catch (Exception e) {
                LogHelper.error((Throwable)e);
            }
            try {
                this.permissionsHandler.close();
            }
            catch (Exception e) {
                LogHelper.error((Throwable)e);
            }
        }
    }
}

