/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.handler;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import pro.gravit.launchserver.auth.handler.CachedAuthHandler;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class MemoryAuthHandler
extends CachedAuthHandler {
    private static String toUsername(UUID uuid) {
        int length;
        byte[] bytes = ByteBuffer.allocate(16).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).array();
        for (length = 0; length < bytes.length && bytes[length] != 0; ++length) {
        }
        return VerifyHelper.verifyUsername((String)new String(bytes, 0, length, IOHelper.ASCII_CHARSET));
    }

    private static UUID toUUID(String username) {
        ByteBuffer buffer = ByteBuffer.wrap(Arrays.copyOf(IOHelper.encodeASCII((String)username), 16));
        return new UUID(buffer.getLong(), buffer.getLong());
    }

    @Override
    public void close() {
    }

    @Override
    protected CachedAuthHandler.Entry fetchEntry(String username) {
        return new CachedAuthHandler.Entry(MemoryAuthHandler.toUUID(username), username, null, null);
    }

    @Override
    protected CachedAuthHandler.Entry fetchEntry(UUID uuid) {
        return new CachedAuthHandler.Entry(uuid, MemoryAuthHandler.toUsername(uuid), null, null);
    }

    @Override
    protected boolean updateAuth(UUID uuid, String username, String accessToken) {
        return true;
    }

    @Override
    protected boolean updateServerID(UUID uuid, String serverID) {
        return true;
    }
}

