/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import pro.gravit.launcher.AutogenConfig;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.modules.Module;
import pro.gravit.launcher.modules.ModulesManager;
import pro.gravit.launchserver.asm.ClassMetadataReader;
import pro.gravit.launchserver.asm.SafeClassWriter;

public class JAConfigurator {
    private static final String modulesManagerName = Type.getInternalName(ModulesManager.class);
    private static final String registerModDesc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Module.class)});
    private static final String autoGenConfigName = Type.getInternalName(AutogenConfig.class);
    private static final String stringName = Type.getInternalName(String.class);
    private final ClassNode configclass;
    private final MethodNode constructor;
    private final MethodNode initModuleMethod;

    public JAConfigurator(ClassNode configclass) {
        this.configclass = configclass;
        this.constructor = configclass.methods.stream().filter(e -> "<init>".equals(e.name)).findFirst().get();
        this.constructor.instructions = new InsnList();
        this.initModuleMethod = configclass.methods.stream().filter(e -> "initModules".equals(e.name)).findFirst().get();
        this.initModuleMethod.instructions = new InsnList();
    }

    public void addModuleClass(String fullName) {
        this.initModuleMethod.instructions.insert((AbstractInsnNode)new MethodInsnNode(185, modulesManagerName, "registerModule", registerModDesc));
        this.initModuleMethod.instructions.insert((AbstractInsnNode)new MethodInsnNode(183, fullName.replace('.', '/'), "<init>", "()V"));
        this.initModuleMethod.instructions.insert((AbstractInsnNode)new TypeInsnNode(187, fullName.replace('.', '/')));
    }

    public byte[] getBytecode(ClassMetadataReader reader) {
        SafeClassWriter cw = new SafeClassWriter(reader, 2);
        this.configclass.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    public String getZipEntryPath() {
        return this.configclass.name.concat(".class");
    }

    public void setAddress(String address) {
        this.constructor.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)address));
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "address", stringName));
    }

    public void setProjectName(String name) {
        this.constructor.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)name));
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "projectname", stringName));
    }

    public void setSecretKey(String key) {
        this.constructor.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)key));
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "secretKeyClient", stringName));
    }

    public void setOemUnlockKey(String key) {
        this.constructor.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)key));
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "oemUnlockKey", stringName));
    }

    public void setGuardType(String key) {
        this.constructor.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)key));
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "guardType", stringName));
    }

    public void push(int value) {
        if (value >= -1 && value <= 5) {
            this.constructor.instructions.add((AbstractInsnNode)new InsnNode(3 + value));
        } else if (value >= -128 && value <= 127) {
            this.constructor.instructions.add((AbstractInsnNode)new IntInsnNode(16, value));
        } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            this.constructor.instructions.add((AbstractInsnNode)new IntInsnNode(17, value));
        } else {
            this.constructor.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)value));
        }
    }

    public void setEnv(LauncherConfig.LauncherEnvironment env) {
        int i = 2;
        switch (env) {
            case DEV: {
                i = 0;
                break;
            }
            case DEBUG: {
                i = 1;
                break;
            }
            case STD: {
                i = 2;
                break;
            }
            case PROD: {
                i = 3;
            }
        }
        this.push(i);
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "env", Type.INT_TYPE.getInternalName()));
    }

    public void setClientPort(int port) {
        this.push(port);
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "clientPort", Type.INT_TYPE.getInternalName()));
    }

    public void setWarningMissArchJava(boolean b) {
        this.constructor.instructions.add((AbstractInsnNode)new InsnNode(b ? 4 : 3));
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "isWarningMissArchJava", Type.BOOLEAN_TYPE.getInternalName()));
    }

    public void setGuardLicense(String name, String key, String encryptKey) {
        this.constructor.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)name));
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "guardLicenseName", stringName));
        this.constructor.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)key));
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "guardLicenseKey", stringName));
        this.constructor.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)encryptKey));
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "guardLicenseEncryptKey", stringName));
    }

    public void nullGuardLicense() {
        this.constructor.instructions.add((AbstractInsnNode)new InsnNode(1));
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "guardLicenseName", stringName));
        this.constructor.instructions.add((AbstractInsnNode)new InsnNode(1));
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "guardLicenseKey", stringName));
        this.constructor.instructions.add((AbstractInsnNode)new InsnNode(1));
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "guardLicenseEncryptKey", stringName));
    }
}

