/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.auth;

import java.util.UUID;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.provider.AuthProvider;
import pro.gravit.launchserver.auth.provider.AuthProviderResult;
import pro.gravit.launchserver.command.Command;
import pro.gravit.utils.helper.LogHelper;

public final class AuthCommand
extends Command {
    public AuthCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "<login> <password> <auth_id>";
    }

    public String getUsageDescription() {
        return "Try to auth with specified login and password";
    }

    public void invoke(String ... args) throws Exception {
        this.verifyArgs(args, 2);
        AuthProviderPair pair = args.length > 2 ? this.server.config.getAuthProviderPair(args[2]) : this.server.config.getAuthProviderPair();
        if (pair == null) {
            throw new IllegalStateException(String.format("Auth %s not found", args[1]));
        }
        String login = args[0];
        String password = args[1];
        AuthProvider provider = pair.provider;
        AuthProviderResult result = provider.auth(login, password, "127.0.0.1");
        UUID uuid = pair.handler.auth(result);
        LogHelper.subInfo((String)"UUID: %s, Username: '%s', Access Token: '%s'", (Object[])new Object[]{uuid, result.username, result.accessToken});
    }
}

