/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.auth;

import java.util.List;
import pro.gravit.launcher.hwid.HWID;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.utils.helper.LogHelper;

public class GetHWIDCommand
extends Command {
    public GetHWIDCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[username]";
    }

    public String getUsageDescription() {
        return "get HWID from username";
    }

    public void invoke(String ... args) throws Exception {
        this.verifyArgs(args, 1);
        List<HWID> target = this.server.config.hwidHandler.getHwid(args[0]);
        for (HWID hwid : target) {
            if (hwid == null) {
                LogHelper.error((String)"HWID %s: null", (Object[])new Object[]{args[0]});
                continue;
            }
            LogHelper.info((String)"HWID %s: %s", (Object[])new Object[]{args[0], hwid.toString()});
        }
        LogHelper.info((String)"Found %d HWID", (Object[])new Object[]{target.size()});
    }
}

