/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.basic;

import java.nio.file.Paths;
import java.security.KeyPair;
import org.bouncycastle.cert.X509CertificateHolder;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.launchserver.socket.handlers.NettyServerSocketHandler;
import pro.gravit.utils.helper.CommonHelper;

public class TestCommand
extends Command {
    private NettyServerSocketHandler handler = null;

    public TestCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return null;
    }

    public String getUsageDescription() {
        return "Test command. Only developer!";
    }

    public void invoke(String ... args) throws Exception {
        this.verifyArgs(args, 1);
        if (this.handler == null) {
            this.handler = new NettyServerSocketHandler(this.server);
        }
        if (args[0].equals("start")) {
            CommonHelper.newThread((String)"Netty Server", (boolean)true, (Runnable)this.handler).start();
        }
        if (args[0].equals("stop")) {
            this.handler.close();
        }
        if (args[0].equals("genCA")) {
            this.server.certificateManager.generateCA();
            this.server.certificateManager.writePrivateKey(Paths.get("ca.key", new String[0]), this.server.certificateManager.caKey);
            this.server.certificateManager.writeCertificate(Paths.get("ca.crt", new String[0]), this.server.certificateManager.ca);
        }
        if (args[0].equals("readCA")) {
            this.server.certificateManager.ca = this.server.certificateManager.readCertificate(Paths.get("ca.crt", new String[0]));
            this.server.certificateManager.caKey = this.server.certificateManager.readPrivateKey(Paths.get("ca.key", new String[0]));
        }
        if (args[0].equals("genCert")) {
            this.verifyArgs(args, 2);
            String name = args[1];
            KeyPair pair = this.server.certificateManager.generateKeyPair();
            X509CertificateHolder cert = this.server.certificateManager.generateCertificate(name, pair.getPublic());
            this.server.certificateManager.writePrivateKey(Paths.get(name.concat(".key"), new String[0]), pair.getPrivate());
            this.server.certificateManager.writeCertificate(Paths.get(name.concat(".crt"), new String[0]), cert);
        }
    }
}

