/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.dump;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.UUID;
import pro.gravit.launcher.Launcher;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.handler.CachedAuthHandler;
import pro.gravit.launchserver.command.Command;
import pro.gravit.utils.command.SubCommand;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class DumpEntryCacheCommand
extends Command {
    public DumpEntryCacheCommand(final LaunchServer server) {
        super(server);
        this.childCommands.put("load", new SubCommand(){

            public void invoke(String ... args) throws Exception {
                int size_username;
                int size_entry;
                this.verifyArgs(args, 2);
                AuthProviderPair pair = server.config.getAuthProviderPair(args[0]);
                if (pair == null) {
                    throw new IllegalStateException(String.format("Auth %s not found", args[0]));
                }
                if (!(pair.handler instanceof CachedAuthHandler)) {
                    throw new UnsupportedOperationException("This command used only CachedAuthHandler");
                }
                CachedAuthHandler authHandler = (CachedAuthHandler)pair.handler;
                LogHelper.info((String)"CachedAuthHandler read from %s", (Object[])new Object[]{args[0]});
                try (BufferedReader reader = IOHelper.newReader((Path)Paths.get(args[1], new String[0]));){
                    EntryAndUsername entryAndUsername = (EntryAndUsername)Launcher.gsonManager.configGson.fromJson((Reader)reader, EntryAndUsername.class);
                    size_entry = entryAndUsername.entryCache.size();
                    size_username = entryAndUsername.usernameCache.size();
                    authHandler.loadEntryCache(entryAndUsername.entryCache);
                    authHandler.loadUsernameCache(entryAndUsername.usernameCache);
                }
                LogHelper.subInfo((String)"Readed %d entryCache %d usernameCache", (Object[])new Object[]{size_entry, size_username});
            }
        });
        this.childCommands.put("unload", new SubCommand(){

            public void invoke(String ... args) throws Exception {
                this.verifyArgs(args, 2);
                AuthProviderPair pair = server.config.getAuthProviderPair(args[0]);
                if (pair == null) {
                    throw new IllegalStateException(String.format("Auth %s not found", args[0]));
                }
                if (!(pair.handler instanceof CachedAuthHandler)) {
                    throw new UnsupportedOperationException("This command used only CachedAuthHandler");
                }
                CachedAuthHandler authHandler = (CachedAuthHandler)pair.handler;
                LogHelper.info((String)"CachedAuthHandler write to %s", (Object[])new Object[]{args[1]});
                Map<UUID, CachedAuthHandler.Entry> entryCache = authHandler.getEntryCache();
                Map<String, UUID> usernamesCache = authHandler.getUsernamesCache();
                EntryAndUsername serializable = new EntryAndUsername();
                serializable.entryCache = entryCache;
                serializable.usernameCache = usernamesCache;
                try (BufferedWriter writer = IOHelper.newWriter((Path)Paths.get(args[1], new String[0]));){
                    Launcher.gsonManager.configGson.toJson((Object)serializable, (Appendable)writer);
                }
                LogHelper.subInfo((String)"Write %d entryCache, %d usernameCache", (Object[])new Object[]{entryCache.size(), usernamesCache.size()});
            }
        });
    }

    public String getArgsDescription() {
        return "[load/unload] [auth_id] [filename]";
    }

    public String getUsageDescription() {
        return "Load or unload AuthHandler Entry cache";
    }

    public void invoke(String ... args) throws Exception {
        this.invokeSubcommands(args);
    }

    public class EntryAndUsername {
        public Map<UUID, CachedAuthHandler.Entry> entryCache;
        public Map<String, UUID> usernameCache;
    }
}

