/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.components;

import java.util.HashMap;
import java.util.Map;
import pro.gravit.launcher.NeedGarbageCollection;

public class AbstractLimiter<T>
implements NeedGarbageCollection {
    public final int maxTrys;
    public final int banMillis;
    protected Map<T, LimitEntry> map = new HashMap<T, LimitEntry>();

    public AbstractLimiter(int maxTrys, int banMillis) {
        this.maxTrys = maxTrys;
        this.banMillis = banMillis;
    }

    public void garbageCollection() {
        long time = System.currentTimeMillis();
        this.map.entrySet().removeIf(e -> ((LimitEntry)e.getValue()).time + (long)this.banMillis < time);
    }

    public boolean check(T address) {
        LimitEntry entry = this.map.get(address);
        if (entry == null) {
            this.map.put(address, new LimitEntry());
            return true;
        }
        long time = System.currentTimeMillis();
        if (entry.trys < this.maxTrys) {
            ++entry.trys;
            entry.time = time;
            return true;
        }
        if (entry.time + (long)this.banMillis < time) {
            entry.trys = 1;
            entry.time = time;
            return true;
        }
        return false;
    }

    class LimitEntry {
        long time;
        int trys;

        public LimitEntry(long time, int trys) {
            this.time = time;
            this.trys = trys;
        }

        public LimitEntry() {
            this.time = System.currentTimeMillis();
            this.trys = 0;
        }
    }
}

