/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.components;

import java.util.ArrayList;
import java.util.List;
import pro.gravit.launcher.NeedGarbageCollection;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.components.AbstractLimiter;
import pro.gravit.launchserver.components.Component;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;
import pro.gravit.utils.HookException;

public class AuthLimiterComponent
extends Component
implements NeedGarbageCollection,
AutoCloseable {
    private transient AbstractLimiter<String> limiter;
    private transient LaunchServer srv;
    public int rateLimit;
    public int rateLimitMilis;
    public String message;
    public List<String> excludeIps = new ArrayList<String>();

    @Override
    public void preInit(LaunchServer launchServer) {
        this.srv = launchServer;
    }

    @Override
    public void init(LaunchServer launchServer) {
        this.limiter = new AbstractLimiter(this.rateLimit, this.rateLimitMilis);
        launchServer.authHookManager.preHook.registerHook(this::preAuthHook);
    }

    @Override
    public void postInit(LaunchServer launchServer) {
    }

    public boolean preAuthHook(AuthResponse.AuthContext context, Client client) {
        if (!this.excludeIps.contains(context.ip) && !this.limiter.check(context.ip)) {
            throw new HookException(this.message);
        }
        return false;
    }

    public void garbageCollection() {
        if (this.limiter != null) {
            this.limiter.garbageCollection();
        }
    }

    @Override
    public void close() throws Exception {
        this.srv.authHookManager.preHook.unregisterHook(this::preAuthHook);
    }
}

