/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.components;

import java.util.ArrayList;
import java.util.List;
import pro.gravit.launcher.NeedGarbageCollection;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.components.AbstractLimiter;
import pro.gravit.launchserver.components.Component;
import pro.gravit.launchserver.manangers.hook.AuthHookManager;
import pro.gravit.utils.HookException;

public class RegLimiterComponent
extends Component
implements NeedGarbageCollection,
AutoCloseable {
    private transient AbstractLimiter<String> limiter;
    public transient LaunchServer launchServer;
    public int rateLimit;
    public int rateLimitMilis;
    public String message;
    public List<String> excludeIps = new ArrayList<String>();

    @Override
    public void preInit(LaunchServer launchServer) {
        this.limiter = new AbstractLimiter(this.rateLimit, this.rateLimitMilis);
        this.launchServer = launchServer;
    }

    @Override
    public void init(LaunchServer launchServer) {
    }

    @Override
    public void postInit(LaunchServer launchServer) {
        launchServer.authHookManager.registraion.registerHook(this::registerHook);
    }

    public boolean registerHook(AuthHookManager.RegContext context) {
        if (!this.limiter.check(context.ip)) {
            throw new HookException(this.message);
        }
        return false;
    }

    public void garbageCollection() {
        if (this.limiter != null) {
            this.limiter.garbageCollection();
        }
    }

    @Override
    public void close() throws Exception {
        this.launchServer.authHookManager.registraion.unregisterHook(this::registerHook);
    }
}

