/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.dao;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launchserver.dao.UserHWID;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

@Entity
@Table(name="users")
public class User {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @Column(unique=true)
    public String username;
    @Column(unique=true)
    public UUID uuid;
    @Column(name="password")
    private byte[] password;
    private String accessToken;
    public String serverID;
    private String password_salt;
    public long permissions;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="user_id")
    public Collection<UserHWID> hwids;

    public void setPassword(String password) {
        MessageDigest digest;
        this.password_salt = SecurityHelper.randomStringAESKey();
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            LogHelper.error((Throwable)e);
            return;
        }
        this.password = digest.digest(password.concat(this.password_salt).getBytes(StandardCharsets.UTF_8));
    }

    public boolean verifyPassword(String password) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            LogHelper.error((Throwable)e);
            return false;
        }
        byte[] enpassword = digest.digest(password.concat(this.password_salt).getBytes(StandardCharsets.UTF_8));
        LogHelper.info((String)Arrays.toString(enpassword));
        LogHelper.info((String)Arrays.toString(this.password));
        return Arrays.equals(enpassword, this.password);
    }

    public ClientPermissions getPermissions() {
        return new ClientPermissions(this.permissions);
    }

    public void setPermissions(ClientPermissions permissions) {
        this.permissions = permissions.toLong();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }
}

