/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.manangers;

import java.util.HashMap;
import java.util.Objects;
import pro.gravit.launchserver.Reloadable;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.VerifyHelper;

public class ReloadManager {
    private final HashMap<String, Reloadable> RELOADABLES = new HashMap();

    public void registerReloadable(String name, Reloadable reloadable) {
        VerifyHelper.putIfAbsent(this.RELOADABLES, (Object)name.toLowerCase(), (Object)Objects.requireNonNull(reloadable, "adapter"), (String)String.format("Reloadable has been already registered: '%s'", name.toLowerCase()));
    }

    public Reloadable unregisterReloadable(String name) {
        return this.RELOADABLES.remove(name);
    }

    public void reloadAll() {
        this.RELOADABLES.forEach((k, v) -> {
            try {
                v.reload();
            }
            catch (Exception e) {
                LogHelper.error((Throwable)e);
            }
        });
    }

    public void reload(String name) throws Exception {
        this.RELOADABLES.get(name.toLowerCase()).reload();
    }

    public void printReloadables() {
        LogHelper.info((String)"Print reloadables");
        this.RELOADABLES.forEach((k, v) -> LogHelper.subInfo((String)k));
        LogHelper.info((String)"Found %d reloadables", (Object[])new Object[]{this.RELOADABLES.size()});
    }
}

