/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.handler;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.MySQLSourceConfig;
import pro.gravit.launchserver.auth.handler.CachedAuthHandler;
import pro.gravit.utils.helper.LogHelper;

public final class MySQLAuthHandler
extends CachedAuthHandler {
    private MySQLSourceConfig mySQLHolder;
    private String uuidColumn;
    private String usernameColumn;
    private String accessTokenColumn;
    private String serverIDColumn;
    private String table;
    private transient String queryByUUIDSQL;
    private transient String queryByUsernameSQL;
    private transient String updateAuthSQL;
    private transient String updateServerIDSQL;

    @Override
    public void init(LaunchServer srv) {
        super.init(srv);
        if (this.mySQLHolder == null) {
            LogHelper.error((String)"[Verify][AuthHandler] mySQLHolder cannot be null");
        }
        if (this.uuidColumn == null) {
            LogHelper.error((String)"[Verify][AuthHandler] uuidColumn cannot be null");
        }
        if (this.usernameColumn == null) {
            LogHelper.error((String)"[Verify][AuthHandler] usernameColumn cannot be null");
        }
        if (this.accessTokenColumn == null) {
            LogHelper.error((String)"[Verify][AuthHandler] accessTokenColumn cannot be null");
        }
        if (this.serverIDColumn == null) {
            LogHelper.error((String)"[Verify][AuthHandler] serverIDColumn cannot be null");
        }
        if (this.table == null) {
            LogHelper.error((String)"[Verify][AuthHandler] table cannot be null");
        }
        this.queryByUUIDSQL = String.format("SELECT %s, %s, %s, %s FROM %s WHERE %s=? LIMIT 1", this.uuidColumn, this.usernameColumn, this.accessTokenColumn, this.serverIDColumn, this.table, this.uuidColumn);
        this.queryByUsernameSQL = String.format("SELECT %s, %s, %s, %s FROM %s WHERE %s=? LIMIT 1", this.uuidColumn, this.usernameColumn, this.accessTokenColumn, this.serverIDColumn, this.table, this.usernameColumn);
        this.updateAuthSQL = String.format("UPDATE %s SET %s=?, %s=?, %s=NULL WHERE %s=? LIMIT 1", this.table, this.usernameColumn, this.accessTokenColumn, this.serverIDColumn, this.uuidColumn);
        this.updateServerIDSQL = String.format("UPDATE %s SET %s=? WHERE %s=? LIMIT 1", this.table, this.serverIDColumn, this.uuidColumn);
    }

    @Override
    public void close() {
        this.mySQLHolder.close();
    }

    private CachedAuthHandler.Entry constructEntry(ResultSet set) throws SQLException {
        return set.next() ? new CachedAuthHandler.Entry(UUID.fromString(set.getString(this.uuidColumn)), set.getString(this.usernameColumn), set.getString(this.accessTokenColumn), set.getString(this.serverIDColumn)) : null;
    }

    @Override
    protected CachedAuthHandler.Entry fetchEntry(String username) throws IOException {
        return this.query(this.queryByUsernameSQL, username);
    }

    @Override
    protected CachedAuthHandler.Entry fetchEntry(UUID uuid) throws IOException {
        return this.query(this.queryByUUIDSQL, uuid.toString());
    }

    /*
     * Exception decompiling
     */
    private CachedAuthHandler.Entry query(String sql, String value) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean updateAuth(UUID uuid, String username, String accessToken) throws IOException {
        try (Connection c = this.mySQLHolder.getConnection();){
            PreparedStatement s = c.prepareStatement(this.updateAuthSQL);
            s.setString(1, username);
            s.setString(2, accessToken);
            s.setString(3, uuid.toString());
            s.setQueryTimeout(MySQLSourceConfig.TIMEOUT);
            boolean bl = s.executeUpdate() > 0;
            return bl;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean updateServerID(UUID uuid, String serverID) throws IOException {
        try (Connection c = this.mySQLHolder.getConnection();){
            PreparedStatement s = c.prepareStatement(this.updateServerIDSQL);
            s.setString(1, serverID);
            s.setString(2, uuid.toString());
            s.setQueryTimeout(MySQLSourceConfig.TIMEOUT);
            boolean bl = s.executeUpdate() > 0;
            return bl;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }
}

