/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.hwid;

import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.hwid.HWID;
import pro.gravit.launchserver.auth.hwid.HWIDException;
import pro.gravit.launchserver.auth.hwid.HWIDHandler;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class JsonFileHWIDHandler
extends HWIDHandler {
    public String filename = "hwids.json";
    public transient LinkedList<Entry> list = new LinkedList();
    public String banMessage = "You banned";

    @Override
    public void ban(List<HWID> hwid) {
        for (Entry e : this.list) {
            for (HWID banHWID : hwid) {
                if (!e.hwid.equals(banHWID)) continue;
                e.isBanned = true;
            }
        }
    }

    @Override
    public void init() {
        Path path = Paths.get(this.filename, new String[0]);
        Type type = new TypeToken<LinkedList<Entry>>(){}.getType();
        try (BufferedReader reader = IOHelper.newReader((Path)path);){
            this.list = (LinkedList)Launcher.gsonManager.gson.fromJson((Reader)reader, type);
        }
        catch (IOException e) {
            LogHelper.error((Throwable)e);
        }
    }

    @Override
    public void check0(HWID hwid, String username) throws HWIDException {
        boolean isOne = false;
        for (Entry e : this.list) {
            if (!e.hwid.equals(hwid)) continue;
            isOne = true;
            if (!e.isBanned) continue;
            throw new HWIDException(this.banMessage);
        }
        if (!isOne) {
            this.list.add(new Entry(hwid));
        }
    }

    @Override
    public void close() throws Exception {
        Path path = Paths.get(this.filename, new String[0]);
        try (BufferedWriter writer = IOHelper.newWriter((Path)path);){
            Launcher.gsonManager.configGson.toJson(this.list, (Appendable)writer);
        }
    }

    @Override
    public List<HWID> getHwid(String username) {
        LinkedList<HWID> hwids = new LinkedList<HWID>();
        for (Entry e : this.list) {
            if (!e.username.equals(username)) continue;
            hwids.add(e.hwid);
        }
        return hwids;
    }

    @Override
    public void unban(List<HWID> hwid) {
        for (Entry e : this.list) {
            for (HWID banHWID : hwid) {
                if (!e.hwid.equals(banHWID)) continue;
                e.isBanned = false;
            }
        }
    }

    public class Entry {
        public HWID hwid;
        public String username;
        public boolean isBanned = false;

        public Entry(HWID hwid) {
            this.hwid = hwid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return Objects.equals(this.hwid, entry.hwid);
        }

        public int hashCode() {
            return Objects.hash(this.hwid);
        }
    }
}

