/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.hwid;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import pro.gravit.launcher.hwid.HWID;
import pro.gravit.launcher.hwid.OshiHWID;
import pro.gravit.launchserver.auth.MySQLSourceConfig;
import pro.gravit.launchserver.auth.hwid.HWIDException;
import pro.gravit.launchserver.auth.hwid.HWIDHandler;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.LogHelper;

public class MysqlHWIDHandler
extends HWIDHandler {
    private MySQLSourceConfig mySQLHolder;
    private String tableUsers;
    private String tableHwids;
    private String userFieldHwid;
    private String userFieldLogin;
    private String hwidFieldTotalMemory;
    private String hwidFieldSerialNumber;
    private String hwidFieldHWDiskSerial;
    private String hwidFieldProcessorID;
    private String hwidFieldBanned;
    private String hwidFieldMAC;
    private String queryHwids;
    private String[] paramsHwids;
    private String queryBan;
    private String[] paramsBan;
    private String banMessage;
    private boolean compareMode = false;
    private int compare = 50;
    private boolean oneCompareMode = false;

    @Override
    public void check0(HWID hwid, String username) throws HWIDException {
        if (hwid instanceof OshiHWID) {
            OshiHWID oshiHWID = (OshiHWID)hwid;
            try (Connection c = this.mySQLHolder.getConnection();){
                PreparedStatement s = c.prepareStatement(String.format("SELECT %s, %s FROM `%s` WHERE `%s` = ? LIMIT 1", this.userFieldHwid, this.userFieldLogin, this.tableUsers, this.userFieldLogin));
                s.setString(1, username);
                s.setQueryTimeout(MySQLSourceConfig.TIMEOUT);
                try (ResultSet set = s.executeQuery();){
                    if (set.next()) {
                        int hwid_id = set.getInt(this.userFieldHwid);
                        if (hwid_id == 0) {
                            this.onUpdateInfo(oshiHWID, username, c);
                        } else {
                            this.onCheckInfo(oshiHWID, username, c);
                        }
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void onUpdateInfo(OshiHWID hwid, String username, Connection c) throws HWIDException {
        try (PreparedStatement a = c.prepareStatement(this.queryHwids);){
            String[] replaceParams = new String[]{"totalMemory", String.valueOf(hwid.totalMemory), "serialNumber", hwid.serialNumber, "HWDiskSerial", hwid.HWDiskSerial, "processorID", hwid.processorID, "MAC", hwid.macAddr};
            for (int i = 0; i < this.paramsHwids.length; ++i) {
                a.setString(i + 1, CommonHelper.replace((String)this.paramsHwids[i], (String[])replaceParams));
            }
            ResultSet set = a.executeQuery();
            if (set.next()) {
                int id = set.getInt("id");
                boolean isBanned = set.getBoolean(this.hwidFieldBanned);
                PreparedStatement ps = c.prepareStatement(String.format("UPDATE `%s` SET `%s` = ? WHERE `%s` = ?", this.tableUsers, this.userFieldHwid, this.userFieldLogin));
                ps.setInt(1, id);
                ps.setString(2, username);
                ps.setQueryTimeout(MySQLSourceConfig.TIMEOUT);
                ps.executeUpdate();
                if (isBanned) {
                    throw new HWIDException(this.banMessage);
                }
            } else {
                PreparedStatement ps = c.prepareStatement(String.format("INSERT INTO `%s` (`%s`, `%s`, `%s`, `%s`, `%s`) VALUES (?, ?, ?, ?, ?);", this.tableHwids, this.hwidFieldTotalMemory, this.hwidFieldSerialNumber, this.hwidFieldHWDiskSerial, this.hwidFieldProcessorID, this.hwidFieldMAC));
                ps.setString(1, String.valueOf(hwid.totalMemory));
                ps.setString(2, hwid.serialNumber);
                ps.setString(3, hwid.HWDiskSerial);
                ps.setString(4, hwid.processorID);
                ps.setString(5, hwid.macAddr);
                ps.setQueryTimeout(MySQLSourceConfig.TIMEOUT);
                ps.executeUpdate();
                ps = c.prepareStatement(String.format("UPDATE `%s` SET `%s` = LAST_INSERT_ID() WHERE `%s` = ?;", this.tableUsers, this.userFieldHwid, this.userFieldLogin));
                ps.setString(1, username);
                ps.setQueryTimeout(MySQLSourceConfig.TIMEOUT);
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void onCheckInfo(OshiHWID hwid, String username, Connection c) throws HWIDException {
        try (PreparedStatement a = c.prepareStatement(this.queryHwids);){
            String[] replaceParams = new String[]{"totalMemory", String.valueOf(hwid.totalMemory), "serialNumber", hwid.serialNumber, "HWDiskSerial", hwid.HWDiskSerial, "processorID", hwid.processorID, "MAC", hwid.macAddr};
            for (int i = 0; i < this.paramsHwids.length; ++i) {
                a.setString(i + 1, CommonHelper.replace((String)this.paramsHwids[i], (String[])replaceParams));
            }
            ResultSet set = a.executeQuery();
            boolean isOne = false;
            while (set.next()) {
                boolean isBanned;
                if (!this.oneCompareMode) {
                    isOne = true;
                }
                if (this.compareMode) {
                    int compare_point;
                    OshiHWID db_hwid = new OshiHWID();
                    db_hwid.serialNumber = set.getString(this.hwidFieldSerialNumber);
                    db_hwid.processorID = set.getString(this.hwidFieldProcessorID);
                    db_hwid.HWDiskSerial = set.getString(this.hwidFieldHWDiskSerial);
                    db_hwid.totalMemory = Long.valueOf(set.getString(this.hwidFieldTotalMemory));
                    db_hwid.macAddr = set.getString(this.hwidFieldMAC);
                    if (LogHelper.isDevEnabled()) {
                        LogHelper.dev((String)"Compare HWID: %s vs %s", (Object[])new Object[]{hwid.getSerializeString(), db_hwid.getSerializeString()});
                    }
                    if ((compare_point = hwid.compare((HWID)db_hwid)) < this.compare) continue;
                    if (LogHelper.isDevEnabled()) {
                        LogHelper.debug((String)"User %s hwid check: found compare %d in %d", (Object[])new Object[]{username, compare_point, set.getInt("id")});
                    }
                }
                if (this.oneCompareMode) {
                    isOne = true;
                }
                if (!(isBanned = set.getBoolean(this.hwidFieldBanned))) continue;
                throw new HWIDException(this.banMessage);
            }
            if (isOne) {
                this.onUpdateInfo(hwid, username, c);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void setIsBanned(HWID hwid, boolean isBanned) {
        if (LogHelper.isDebugEnabled()) {
            LogHelper.debug((String)"%s Request HWID: %s", (Object[])new Object[]{isBanned ? "Ban" : "UnBan", hwid.toString()});
        }
        if (hwid instanceof OshiHWID) {
            OshiHWID oshiHWID = (OshiHWID)hwid;
            try (Connection c = this.mySQLHolder.getConnection();){
                try (PreparedStatement a = c.prepareStatement(this.queryBan);){
                    String[] replaceParamsUpd = new String[]{"totalMemory", String.valueOf(oshiHWID.totalMemory), "serialNumber", oshiHWID.serialNumber, "HWDiskSerial", oshiHWID.HWDiskSerial, "processorID", oshiHWID.processorID, "MAC", oshiHWID.macAddr, "isBanned", isBanned ? "1" : "0"};
                    for (int i = 0; i < this.paramsBan.length; ++i) {
                        a.setString(i + 1, CommonHelper.replace((String)this.paramsBan[i], (String[])replaceParamsUpd));
                    }
                    a.setQueryTimeout(MySQLSourceConfig.TIMEOUT);
                    a.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void ban(List<HWID> list) {
        for (HWID hwid : list) {
            this.setIsBanned(hwid, true);
        }
    }

    @Override
    public void unban(List<HWID> list) {
        for (HWID hwid : list) {
            this.setIsBanned(hwid, false);
        }
    }

    @Override
    public List<HWID> getHwid(String username) {
        ArrayList<HWID> list = new ArrayList<HWID>();
        try (Connection c = this.mySQLHolder.getConnection();){
            if (LogHelper.isDebugEnabled()) {
                LogHelper.debug((String)"Try find HWID from username %s", (Object[])new Object[]{username});
            }
            PreparedStatement s = c.prepareStatement(String.format("SELECT %s, %s FROM `%s` WHERE `%s` = ? LIMIT 1", this.userFieldHwid, this.userFieldLogin, this.tableUsers, this.userFieldLogin));
            s.setString(1, username);
            s.setQueryTimeout(MySQLSourceConfig.TIMEOUT);
            try (ResultSet set = s.executeQuery();){
                if (set.next()) {
                    int hwid_id = set.getInt(this.userFieldHwid);
                    if (hwid_id != 0) {
                        s = c.prepareStatement(String.format("SELECT * FROM `%s` WHERE `id` = ? LIMIT 1", this.tableHwids));
                        s.setInt(1, hwid_id);
                        ResultSet rs = s.executeQuery();
                        if (rs.next()) {
                            OshiHWID oshiHWID = new OshiHWID();
                            oshiHWID.totalMemory = Long.valueOf(rs.getString(this.hwidFieldTotalMemory));
                            oshiHWID.serialNumber = rs.getString(this.hwidFieldSerialNumber);
                            oshiHWID.HWDiskSerial = rs.getString(this.hwidFieldHWDiskSerial);
                            oshiHWID.processorID = rs.getString(this.hwidFieldProcessorID);
                            oshiHWID.macAddr = rs.getString(this.hwidFieldMAC);
                            list.add((HWID)oshiHWID);
                        }
                    }
                } else {
                    LogHelper.error((Throwable)new HWIDException("HWID not found"));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public void close() {
        this.mySQLHolder.close();
    }

    @Override
    public void init() {
    }
}

