/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.provider;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.net.URL;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launchserver.auth.provider.AuthProvider;
import pro.gravit.launchserver.auth.provider.AuthProviderResult;
import pro.gravit.utils.HTTPRequest;
import pro.gravit.utils.helper.SecurityHelper;

public final class JsonAuthProvider
extends AuthProvider {
    private static Gson gson = new Gson();
    private URL url;
    private String apiKey;

    @Override
    public AuthProviderResult auth(String login, String password, String ip) throws IOException {
        authRequest authRequest2 = new authRequest(login, password, ip, this.apiKey);
        JsonElement request = gson.toJsonTree((Object)authRequest2);
        JsonElement content = HTTPRequest.jsonRequest((JsonElement)request, (URL)this.url);
        if (!content.isJsonObject()) {
            return JsonAuthProvider.authError("Authentication server response is malformed");
        }
        authResult result = (authResult)gson.fromJson(content, authResult.class);
        if (result.username != null) {
            return new AuthProviderResult(result.username, SecurityHelper.randomStringToken(), new ClientPermissions(result.permissions));
        }
        if (result.error != null) {
            return JsonAuthProvider.authError(result.error);
        }
        return JsonAuthProvider.authError("Authentication server response is malformed");
    }

    @Override
    public void close() {
    }

    public class authRequest {
        String username;
        String password;
        String ip;
        String apiKey;

        public authRequest(String username, String password, String ip) {
            this.username = username;
            this.password = password;
            this.ip = ip;
        }

        public authRequest(String username, String password, String ip, String apiKey) {
            this.username = username;
            this.password = password;
            this.ip = ip;
            this.apiKey = apiKey;
        }
    }

    public class authResult {
        String username;
        String error;
        long permissions;
    }
}

