/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import pro.gravit.launcher.AutogenConfig;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launchserver.asm.ClassMetadataReader;
import pro.gravit.launchserver.asm.SafeClassWriter;

public class LauncherConfigurator {
    private static final String modulesManagerName = "pro/gravit/launcher/modules/LauncherModulesManager";
    private static final String launcherName = "pro/gravit/launcher/LauncherEngine";
    private static final String modulesManagerDesc = "Lpro/gravit/launcher/client/ClientModuleManager;";
    private static final String registerModDesc = Type.getMethodDescriptor((Type)Type.getType(LauncherModule.class), (Type[])new Type[]{Type.getType(LauncherModule.class)});
    private static final String autoGenConfigName = Type.getInternalName(AutogenConfig.class);
    private static final String stringDesc = Type.getDescriptor(String.class);
    private final ClassNode configclass;
    private final MethodNode constructor;
    private final MethodNode initModuleMethod;

    public LauncherConfigurator(ClassNode configclass) {
        this.configclass = configclass;
        this.constructor = configclass.methods.stream().filter(e -> "<init>".equals(e.name)).findFirst().get();
        this.constructor.instructions = new InsnList();
        this.constructor.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        this.constructor.instructions.add((AbstractInsnNode)new MethodInsnNode(183, Type.getInternalName(Object.class), "<init>", "()V"));
        this.initModuleMethod = configclass.methods.stream().filter(e -> "initModules".equals(e.name)).findFirst().get();
        this.initModuleMethod.instructions = new InsnList();
    }

    public void addModuleClass(String fullName) {
        this.initModuleMethod.instructions.add((AbstractInsnNode)new FieldInsnNode(178, launcherName, "modulesManager", modulesManagerDesc));
        this.initModuleMethod.instructions.add((AbstractInsnNode)new TypeInsnNode(187, fullName.replace('.', '/')));
        this.initModuleMethod.instructions.add((AbstractInsnNode)new InsnNode(89));
        this.initModuleMethod.instructions.add((AbstractInsnNode)new MethodInsnNode(183, fullName.replace('.', '/'), "<init>", "()V"));
        this.initModuleMethod.instructions.add((AbstractInsnNode)new MethodInsnNode(185, modulesManagerName, "loadModule", registerModDesc));
    }

    public byte[] getBytecode(ClassMetadataReader reader) {
        this.constructor.instructions.add((AbstractInsnNode)new InsnNode(177));
        this.initModuleMethod.instructions.add((AbstractInsnNode)new InsnNode(177));
        SafeClassWriter cw = new SafeClassWriter(reader, 2);
        this.configclass.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    public String getZipEntryPath() {
        return this.configclass.name.concat(".class");
    }

    public void setAddress(String address) {
        this.constructor.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        this.constructor.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)address));
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "address", stringDesc));
    }

    public void setProjectName(String name) {
        this.constructor.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        this.constructor.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)name));
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "projectname", stringDesc));
    }

    public void setSecretKey(String key) {
        this.constructor.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        this.constructor.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)key));
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "secretKeyClient", stringDesc));
    }

    public void setOemUnlockKey(String key) {
        this.constructor.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        this.constructor.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)key));
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "oemUnlockKey", stringDesc));
    }

    public void setGuardType(String key) {
        this.constructor.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        this.constructor.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)key));
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "guardType", stringDesc));
    }

    public void push(int value) {
        if (value >= -1 && value <= 5) {
            this.constructor.instructions.add((AbstractInsnNode)new InsnNode(3 + value));
        } else if (value >= -128 && value <= 127) {
            this.constructor.instructions.add((AbstractInsnNode)new IntInsnNode(16, value));
        } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            this.constructor.instructions.add((AbstractInsnNode)new IntInsnNode(17, value));
        } else {
            this.constructor.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)value));
        }
    }

    public void setEnv(LauncherConfig.LauncherEnvironment env) {
        this.constructor.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        int i = 2;
        switch (env) {
            case DEV: {
                i = 0;
                break;
            }
            case DEBUG: {
                i = 1;
                break;
            }
            case STD: {
                i = 2;
                break;
            }
            case PROD: {
                i = 3;
            }
        }
        this.push(i);
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "env", Type.INT_TYPE.getInternalName()));
    }

    public void setClientPort(int port) {
        this.constructor.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        this.push(port);
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "clientPort", Type.INT_TYPE.getInternalName()));
    }

    public void setWarningMissArchJava(boolean b) {
        this.constructor.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        this.constructor.instructions.add((AbstractInsnNode)new InsnNode(b ? 4 : 3));
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "isWarningMissArchJava", Type.BOOLEAN_TYPE.getInternalName()));
    }

    public void setGuardLicense(String name, String key, String encryptKey) {
        this.constructor.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        this.constructor.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)name));
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "guardLicenseName", stringDesc));
        this.constructor.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        this.constructor.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)key));
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "guardLicenseKey", stringDesc));
        this.constructor.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        this.constructor.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)encryptKey));
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "guardLicenseEncryptKey", stringDesc));
    }

    public void nullGuardLicense() {
        this.constructor.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        this.constructor.instructions.add((AbstractInsnNode)new InsnNode(1));
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "guardLicenseName", stringDesc));
        this.constructor.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        this.constructor.instructions.add((AbstractInsnNode)new InsnNode(1));
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "guardLicenseKey", stringDesc));
        this.constructor.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        this.constructor.instructions.add((AbstractInsnNode)new InsnNode(1));
        this.constructor.instructions.add((AbstractInsnNode)new FieldInsnNode(181, autoGenConfigName, "guardLicenseEncryptKey", stringDesc));
    }
}

