/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.binary.LauncherBinary;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class SimpleEXELauncherBinary
extends LauncherBinary {
    public Path exeTemplate;

    public SimpleEXELauncherBinary(LaunchServer server) {
        super(server, LauncherBinary.resolve(server, ".exe"));
        this.exeTemplate = server.dir.resolve("SimpleTemplate.exe");
    }

    @Override
    public void build() throws IOException {
        if (!IOHelper.isFile((Path)this.exeTemplate)) {
            LogHelper.warning((String)"[SimpleEXEBinary] File %s not found. %s not created", (Object[])new Object[]{this.exeTemplate.toString(), this.syncBinaryFile.toString()});
            return;
        }
        try (OutputStream output = IOHelper.newOutput((Path)this.syncBinaryFile);){
            IOHelper.transfer((Path)this.exeTemplate, (OutputStream)output);
            IOHelper.transfer((Path)this.server.launcherBinary.syncBinaryFile, (OutputStream)output);
        }
    }
}

