/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary.tasks;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.asm.ClassMetadataReader;
import pro.gravit.launchserver.asm.SafeClassWriter;
import pro.gravit.launchserver.binary.tasks.LauncherBuildTask;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class AdditionalFixesApplyTask
implements LauncherBuildTask {
    private final LaunchServer server;

    public AdditionalFixesApplyTask(LaunchServer server) {
        this.server = server;
    }

    @Override
    public String getName() {
        return "AdditionalFixesApply";
    }

    @Override
    public Path process(Path inputFile) throws IOException {
        Path out = this.server.launcherBinary.nextPath("post-fixed");
        try (ZipOutputStream output = new ZipOutputStream(IOHelper.newOutput((Path)out));){
            AdditionalFixesApplyTask.apply(inputFile, inputFile, output, this.server, e -> false);
        }
        return out;
    }

    public static void apply(Path inputFile, Path addFile, ZipOutputStream output, LaunchServer srv, Predicate<ZipEntry> excluder) throws IOException {
        try (ClassMetadataReader reader = new ClassMetadataReader();){
            reader.getCp().add(new JarFile(inputFile.toFile()));
            List libs = srv.launcherBinary.coreLibs.stream().map(e -> {
                try {
                    return new JarFile(e.toFile());
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
            }).collect(Collectors.toList());
            libs.addAll(srv.launcherBinary.addonLibs.stream().map(e -> {
                try {
                    return new JarFile(e.toFile());
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
            }).collect(Collectors.toList()));
            try (ZipInputStream input = IOHelper.newZipInput((Path)addFile);){
                ZipEntry e2 = input.getNextEntry();
                while (e2 != null) {
                    if (e2.isDirectory() || excluder.test(e2)) {
                        e2 = input.getNextEntry();
                        continue;
                    }
                    String filename = e2.getName();
                    output.putNextEntry(IOHelper.newZipEntry((ZipEntry)e2));
                    if (filename.endsWith(".class")) {
                        byte[] bytes;
                        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(2048);){
                            IOHelper.transfer((InputStream)input, (OutputStream)outputStream);
                            bytes = outputStream.toByteArray();
                        }
                        try {
                            bytes = AdditionalFixesApplyTask.classFix(bytes, reader, srv.config.launcher.stripLineNumbers);
                        }
                        catch (Throwable t) {
                            LogHelper.subWarning((String)("Error on fixing class: " + t));
                        }
                        output.write(bytes);
                    } else {
                        IOHelper.transfer((InputStream)input, (OutputStream)output);
                    }
                    e2 = input.getNextEntry();
                }
            }
        }
    }

    private static byte[] classFix(byte[] bytes, ClassMetadataReader reader, boolean stripNumbers) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, stripNumbers ? 6 : 4);
        SafeClassWriter cw = new SafeClassWriter(reader, 3);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    @Override
    public boolean allowDelete() {
        return true;
    }
}

