/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.dao;

import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.launchserver.dao.User;
import pro.gravit.utils.helper.LogHelper;

public class SetUserPasswordCommand
extends Command {
    public SetUserPasswordCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[username] [new password]";
    }

    public String getUsageDescription() {
        return "Set user password";
    }

    public void invoke(String ... args) throws Exception {
        this.verifyArgs(args, 2);
        User user = this.server.config.dao.userService.findUserByUsername(args[0]);
        if (user == null) {
            LogHelper.error((String)"User %s not found", (Object[])new Object[]{args[1]});
            return;
        }
        user.setPassword(args[1]);
        this.server.config.dao.userService.updateUser(user);
        LogHelper.info((String)"[%s] UUID: %s | New Password: %s", (Object[])new Object[]{user.username, user.uuid.toString(), args[1]});
    }
}

