/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.hash;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.utils.HttpDownloader;
import pro.gravit.utils.command.CommandException;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public final class DownloadClientCommand
extends Command {
    public DownloadClientCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[version] [dir]";
    }

    public String getUsageDescription() {
        return "Download client dir";
    }

    public void invoke(String ... args) throws IOException, CommandException {
        ClientProfile client;
        this.verifyArgs(args, 2);
        ClientProfile.Version version = ClientProfile.Version.byName((String)args[0]);
        String dirName = IOHelper.verifyFileName((String)args[1]);
        Path clientDir = this.server.updatesDir.resolve(args[1]);
        LogHelper.subInfo((String)"Creating client dir: '%s'", (Object[])new Object[]{dirName});
        Files.createDirectory(clientDir, new FileAttribute[0]);
        LogHelper.subInfo((String)"Downloading client, it may take some time");
        HttpDownloader.downloadZip((URL)this.server.mirrorManager.getDefaultMirror().getClientsURL(version.name), (Path)clientDir);
        LogHelper.subInfo((String)"Creaing profile file: '%s'", (Object[])new Object[]{dirName});
        String profilePath = String.format("pro/gravit/launchserver/defaults/profile%s.cfg", version.name);
        try (BufferedReader reader = IOHelper.newReader((URL)IOHelper.getResourceURL((String)profilePath));){
            client = (ClientProfile)Launcher.gsonManager.configGson.fromJson((Reader)reader, ClientProfile.class);
        }
        client.setTitle(dirName);
        client.setDir(dirName);
        var8_7 = null;
        try (BufferedWriter writer = IOHelper.newWriter((Path)IOHelper.resolveIncremental((Path)this.server.profilesDir, (String)dirName, (String)"json"));){
            Launcher.gsonManager.configGson.toJson((Object)client, (Appendable)writer);
        }
        catch (Throwable throwable) {
            var8_7 = throwable;
            throw throwable;
        }
        this.server.syncProfilesDir();
        this.server.syncUpdatesDir(Collections.singleton(dirName));
        LogHelper.subInfo((String)"Client successfully downloaded: '%s'", (Object[])new Object[]{dirName});
    }
}

