/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.hash;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.utils.command.CommandException;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public final class IndexAssetCommand
extends Command {
    private static Gson gson = new Gson();
    public static final String INDEXES_DIR = "indexes";
    public static final String OBJECTS_DIR = "objects";
    private static final String JSON_EXTENSION = ".json";

    public static Path resolveIndexFile(Path assetDir, String name) {
        return assetDir.resolve(INDEXES_DIR).resolve(name + JSON_EXTENSION);
    }

    public static Path resolveObjectFile(Path assetDir, String hash) {
        return assetDir.resolve(OBJECTS_DIR).resolve(hash.substring(0, 2)).resolve(hash);
    }

    public IndexAssetCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[dir] [index] [output-dir]";
    }

    public String getUsageDescription() {
        return "Index asset dir (1.7.10+)";
    }

    public void invoke(String ... args) throws Exception {
        this.verifyArgs(args, 3);
        String inputAssetDirName = IOHelper.verifyFileName((String)args[0]);
        String indexFileName = IOHelper.verifyFileName((String)args[1]);
        String outputAssetDirName = IOHelper.verifyFileName((String)args[2]);
        Path inputAssetDir = this.server.updatesDir.resolve(inputAssetDirName);
        Path outputAssetDir = this.server.updatesDir.resolve(outputAssetDirName);
        if (outputAssetDir.equals(inputAssetDir)) {
            throw new CommandException("Unindexed and indexed asset dirs can't be same");
        }
        LogHelper.subInfo((String)"Creating indexed asset dir: '%s'", (Object[])new Object[]{outputAssetDirName});
        Files.createDirectory(outputAssetDir, new FileAttribute[0]);
        JsonObject objects = new JsonObject();
        LogHelper.subInfo((String)"Indexing objects");
        IOHelper.walk((Path)inputAssetDir, (FileVisitor)new IndexAssetVisitor(objects, inputAssetDir, outputAssetDir), (boolean)false);
        LogHelper.subInfo((String)"Writing asset index file: '%s'", (Object[])new Object[]{indexFileName});
        try (BufferedWriter writer = IOHelper.newWriter((Path)IndexAssetCommand.resolveIndexFile(outputAssetDir, indexFileName));){
            JsonObject result = new JsonObject();
            result.add(OBJECTS_DIR, (JsonElement)objects);
            writer.write(gson.toJson((JsonElement)result));
        }
        this.server.syncUpdatesDir(Collections.singleton(outputAssetDirName));
        LogHelper.subInfo((String)"Asset successfully indexed: '%s'", (Object[])new Object[]{inputAssetDirName});
    }

    private static final class IndexAssetVisitor
    extends SimpleFileVisitor<Path> {
        private final JsonObject objects;
        private final Path inputAssetDir;
        private final Path outputAssetDir;

        private IndexAssetVisitor(JsonObject objects, Path inputAssetDir, Path outputAssetDir) {
            this.objects = objects;
            this.inputAssetDir = inputAssetDir;
            this.outputAssetDir = outputAssetDir;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            String name = IOHelper.toString((Path)this.inputAssetDir.relativize(file));
            LogHelper.subInfo((String)"Indexing: '%s'", (Object[])new Object[]{name});
            String digest = SecurityHelper.toHex((byte[])SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.SHA1, (Path)file));
            IndexObject obj = new IndexObject(attrs.size(), digest);
            this.objects.add(name, gson.toJsonTree((Object)obj));
            IOHelper.copy((Path)file, (Path)IndexAssetCommand.resolveObjectFile(this.outputAssetDir, digest));
            return super.visitFile(file, attrs);
        }
    }

    public static class IndexObject {
        long size;
        String hash;

        public IndexObject(long size, String hash) {
            this.size = size;
            this.hash = hash;
        }
    }
}

