/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.config;

import io.netty.channel.epoll.Epoll;
import io.netty.handler.logging.LogLevel;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.handler.MemoryAuthHandler;
import pro.gravit.launchserver.auth.hwid.AcceptHWIDHandler;
import pro.gravit.launchserver.auth.hwid.HWIDHandler;
import pro.gravit.launchserver.auth.permissions.DefaultPermissionsHandler;
import pro.gravit.launchserver.auth.permissions.JsonFilePermissionsHandler;
import pro.gravit.launchserver.auth.permissions.PermissionsHandler;
import pro.gravit.launchserver.auth.protect.ProtectHandler;
import pro.gravit.launchserver.auth.protect.StdProtectHandler;
import pro.gravit.launchserver.auth.provider.RejectAuthProvider;
import pro.gravit.launchserver.auth.texture.RequestTextureProvider;
import pro.gravit.launchserver.components.AuthLimiterComponent;
import pro.gravit.launchserver.components.Component;
import pro.gravit.launchserver.components.RegLimiterComponent;
import pro.gravit.launchserver.dao.provider.DaoProvider;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public final class LaunchServerConfig {
    private transient LaunchServer server = null;
    public String projectName;
    public String[] mirrors;
    public String binaryName;
    public boolean copyBinaries = true;
    public LauncherConfig.LauncherEnvironment env;
    public AuthProviderPair[] auth;
    public DaoProvider dao;
    private transient AuthProviderPair authDefault;
    public ProtectHandler protectHandler;
    public PermissionsHandler permissionsHandler;
    public HWIDHandler hwidHandler;
    public Map<String, Component> components;
    public ExeConf launch4j;
    public NettyConfig netty;
    public GuardLicenseConf guardLicense;
    public String whitelistRejectString;
    public LauncherConf launcher;
    public CertificateConf certificate;
    public String startScript;

    public LaunchServerConfig setLaunchServer(LaunchServer server) {
        this.server = server;
        return this;
    }

    public AuthProviderPair getAuthProviderPair(String name) {
        for (AuthProviderPair pair : this.auth) {
            if (!pair.name.equals(name)) continue;
            return pair;
        }
        return null;
    }

    public AuthProviderPair getAuthProviderPair() {
        if (this.authDefault != null) {
            return this.authDefault;
        }
        for (AuthProviderPair pair : this.auth) {
            if (!pair.isDefault) continue;
            this.authDefault = pair;
            return pair;
        }
        return null;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setBinaryName(String binaryName) {
        this.binaryName = binaryName;
    }

    public void setEnv(LauncherConfig.LauncherEnvironment env) {
        this.env = env;
    }

    public void verify() {
        if (this.auth == null || this.auth[0] == null) {
            throw new NullPointerException("AuthHandler must not be null");
        }
        boolean isOneDefault = false;
        for (AuthProviderPair pair : this.auth) {
            if (!pair.isDefault) continue;
            isOneDefault = true;
            break;
        }
        if (this.protectHandler == null) {
            throw new NullPointerException("ProtectHandler must not be null");
        }
        if (!isOneDefault) {
            throw new IllegalStateException("No auth pairs declared by default.");
        }
        if (this.permissionsHandler == null) {
            throw new NullPointerException("PermissionsHandler must not be null");
        }
        if (this.env == null) {
            throw new NullPointerException("Env must not be null");
        }
        if (this.netty == null) {
            throw new NullPointerException("Netty must not be null");
        }
    }

    public void init(LaunchServer.ReloadType type) {
        Launcher.applyLauncherEnv((LauncherConfig.LauncherEnvironment)this.env);
        for (AuthProviderPair provider : this.auth) {
            provider.init(this.server);
        }
        this.permissionsHandler.init(this.server);
        this.hwidHandler.init();
        if (this.dao != null) {
            this.dao.init(this.server);
        }
        if (this.protectHandler != null) {
            this.protectHandler.checkLaunchServerLicense();
        }
        if (this.components != null) {
            this.components.forEach((k, v) -> this.server.registerObject("component.".concat((String)k), v));
        }
        this.server.registerObject("permissionsHandler", this.permissionsHandler);
        this.server.registerObject("hwidHandler", this.hwidHandler);
        if (!type.equals((Object)LaunchServer.ReloadType.NO_AUTH)) {
            for (int i = 0; i < this.auth.length; ++i) {
                AuthProviderPair pair = this.auth[i];
                this.server.registerObject("auth.".concat(pair.name).concat(".provider"), pair.provider);
                this.server.registerObject("auth.".concat(pair.name).concat(".handler"), pair.handler);
                this.server.registerObject("auth.".concat(pair.name).concat(".texture"), pair.textureProvider);
            }
        }
        Arrays.stream(this.mirrors).forEach(this.server.mirrorManager::addMirror);
    }

    public void close(LaunchServer.ReloadType type) {
        try {
            this.server.unregisterObject("permissionsHandler", this.permissionsHandler);
            this.server.unregisterObject("hwidHandler", this.hwidHandler);
            if (!type.equals((Object)LaunchServer.ReloadType.NO_AUTH)) {
                for (AuthProviderPair pair : this.auth) {
                    this.server.unregisterObject("auth.".concat(pair.name).concat(".provider"), pair.provider);
                    this.server.unregisterObject("auth.".concat(pair.name).concat(".handler"), pair.handler);
                    this.server.unregisterObject("auth.".concat(pair.name).concat(".texture"), pair.textureProvider);
                }
            }
            if (type.equals((Object)LaunchServer.ReloadType.FULL)) {
                this.components.forEach((k, component) -> {
                    this.server.unregisterObject("component.".concat((String)k), component);
                    if (component instanceof AutoCloseable) {
                        try {
                            ((AutoCloseable)((Object)component)).close();
                        }
                        catch (Exception e) {
                            LogHelper.error((Throwable)e);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            LogHelper.error((Throwable)e);
        }
        try {
            for (AuthProviderPair p : this.auth) {
                p.close();
            }
        }
        catch (IOException e) {
            LogHelper.error((Throwable)e);
        }
        try {
            this.hwidHandler.close();
        }
        catch (Exception e) {
            LogHelper.error((Throwable)e);
        }
        try {
            this.permissionsHandler.close();
        }
        catch (Exception e) {
            LogHelper.error((Throwable)e);
        }
    }

    public static LaunchServerConfig getDefault(LaunchServer.LaunchServerEnv env) {
        LaunchServerConfig newConfig = new LaunchServerConfig();
        newConfig.mirrors = new String[]{"https://mirror.gravit.pro/"};
        newConfig.launch4j = new ExeConf();
        newConfig.launch4j.enabled = true;
        newConfig.launch4j.copyright = "\u00a9 GravitLauncher Team";
        newConfig.launch4j.alternative = "no";
        newConfig.launch4j.fileDesc = "GravitLauncher ".concat(Version.getVersion().getVersionString());
        newConfig.launch4j.fileVer = Version.getVersion().getVersionString().concat(".").concat(String.valueOf(Version.getVersion().patch));
        newConfig.launch4j.internalName = "Launcher";
        newConfig.launch4j.trademarks = "This product is licensed under GPLv3";
        newConfig.launch4j.txtFileVersion = "%s, build %d";
        newConfig.launch4j.txtProductVersion = "%s, build %d";
        newConfig.launch4j.productName = "GravitLauncher";
        newConfig.launch4j.productVer = newConfig.launch4j.fileVer;
        newConfig.launch4j.maxVersion = "1.8.999";
        newConfig.env = LauncherConfig.LauncherEnvironment.STD;
        newConfig.startScript = JVMHelper.OS_TYPE.equals((Object)JVMHelper.OS.MUSTDIE) ? "." + File.separator + "start.bat" : "." + File.separator + "start.sh";
        newConfig.hwidHandler = new AcceptHWIDHandler();
        newConfig.auth = new AuthProviderPair[]{new AuthProviderPair(new RejectAuthProvider("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u0442\u0435 authProvider"), new MemoryAuthHandler(), new RequestTextureProvider("http://example.com/skins/%username%.png", "http://example.com/cloaks/%username%.png"), "std")};
        newConfig.auth[0].displayName = "Default";
        newConfig.protectHandler = new StdProtectHandler();
        newConfig.permissionsHandler = env.equals((Object)LaunchServer.LaunchServerEnv.TEST) ? new DefaultPermissionsHandler() : new JsonFilePermissionsHandler();
        newConfig.binaryName = "Launcher";
        newConfig.whitelistRejectString = "\u0412\u0430\u0441 \u043d\u0435\u0442 \u0432 \u0431\u0435\u043b\u043e\u043c \u0441\u043f\u0438\u0441\u043a\u0435";
        newConfig.netty = new NettyConfig();
        newConfig.netty.fileServerEnabled = true;
        newConfig.netty.binds = new NettyBindAddress[]{new NettyBindAddress("0.0.0.0", 9274)};
        newConfig.netty.performance = new NettyPerformanceConfig();
        newConfig.netty.performance.usingEpoll = Epoll.isAvailable();
        newConfig.netty.performance.bossThread = 2;
        newConfig.netty.performance.workerThread = 8;
        newConfig.launcher = new LauncherConf();
        newConfig.launcher.guardType = "no";
        newConfig.launcher.compress = true;
        newConfig.launcher.warningMissArchJava = true;
        newConfig.launcher.attachLibraryBeforeProGuard = false;
        newConfig.launcher.deleteTempFiles = true;
        newConfig.launcher.enabledProGuard = true;
        newConfig.launcher.stripLineNumbers = true;
        newConfig.launcher.proguardGenMappings = true;
        newConfig.certificate = new CertificateConf();
        newConfig.certificate.enabled = false;
        newConfig.components = new HashMap<String, Component>();
        AuthLimiterComponent authLimiterComponent = new AuthLimiterComponent();
        authLimiterComponent.rateLimit = 3;
        authLimiterComponent.rateLimitMillis = 8000;
        authLimiterComponent.message = "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043b\u0438\u043c\u0438\u0442 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0439";
        newConfig.components.put("authLimiter", authLimiterComponent);
        RegLimiterComponent regLimiterComponent = new RegLimiterComponent();
        regLimiterComponent.rateLimit = 3;
        regLimiterComponent.rateLimitMillis = 36000000;
        regLimiterComponent.message = "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043b\u0438\u043c\u0438\u0442 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0439";
        newConfig.components.put("regLimiter", regLimiterComponent);
        newConfig.netty.sendExceptionEnabled = true;
        return newConfig;
    }

    public static class GuardLicenseConf {
        public String name;
        public String key;
        public String encryptKey;
    }

    public static class NettyBindAddress {
        public String address;
        public int port;

        public NettyBindAddress(String address, int port) {
            this.address = address;
            this.port = port;
        }
    }

    public static class NettyPerformanceConfig {
        public boolean usingEpoll;
        public int bossThread;
        public int workerThread;
    }

    public static class NettyConfig {
        public boolean fileServerEnabled;
        public boolean sendExceptionEnabled;
        public boolean ipForwarding;
        public boolean showHiddenFiles;
        public String launcherURL;
        public String downloadURL;
        public String launcherEXEURL;
        public String address;
        public Map<String, NettyUpdatesBind> bindings = new HashMap<String, NettyUpdatesBind>();
        public NettyPerformanceConfig performance;
        public NettyBindAddress[] binds;
        public LogLevel logLevel = LogLevel.DEBUG;
    }

    public static class LauncherConf {
        public String guardType;
        public boolean attachLibraryBeforeProGuard;
        public boolean compress;
        public boolean warningMissArchJava;
        public boolean enabledProGuard;
        public boolean stripLineNumbers;
        public boolean deleteTempFiles;
        public boolean proguardGenMappings;
    }

    public static class NettyUpdatesBind {
        public String url;
        public boolean zip;
    }

    public static class CertificateConf {
        public boolean enabled;
    }

    public static class ExeConf {
        public boolean enabled;
        public String alternative;
        public boolean setMaxVersion;
        public String maxVersion;
        public String productName;
        public String productVer;
        public String fileDesc;
        public String fileVer;
        public String internalName;
        public String copyright;
        public String trademarks;
        public String txtFileVersion;
        public String txtProductVersion;
    }
}

