/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.dao;

import java.util.List;
import java.util.UUID;
import pro.gravit.launchserver.dao.User;
import pro.gravit.launchserver.dao.UserDAO;

public class UserService {
    private final UserDAO usersDao;

    public UserService(UserDAO usersDAO) {
        this.usersDao = usersDAO;
    }

    public User findUser(int id) {
        return this.usersDao.findById(id);
    }

    public User findUserByUsername(String username) {
        return this.usersDao.findByUsername(username);
    }

    public User findUserByUUID(UUID uuid) {
        return this.usersDao.findByUUID(uuid);
    }

    public User registerNewUser(String username, String password) {
        User user = new User();
        user.username = username;
        user.setPassword(password);
        user.uuid = UUID.randomUUID();
        return user;
    }

    public void saveUser(User user) {
        this.usersDao.save(user);
    }

    public void deleteUser(User user) {
        this.usersDao.delete(user);
    }

    public void updateUser(User user) {
        this.usersDao.update(user);
    }

    public List<User> findAllUsers() {
        return this.usersDao.findAll();
    }
}

