/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.handlers;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import pro.gravit.launcher.ssl.LauncherKeyStore;
import pro.gravit.launcher.ssl.LauncherTrustManager;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.config.LaunchServerConfig;
import pro.gravit.launchserver.socket.LauncherNettyServer;
import pro.gravit.utils.helper.LogHelper;

public final class NettyServerSocketHandler
implements Runnable,
AutoCloseable {
    private SSLServerSocketFactory ssf;
    public volatile boolean logConnections = Boolean.getBoolean("launcher.logConnections");
    public LauncherNettyServer nettyServer;
    private Set<Socket> sockets;
    private final transient LaunchServer server;

    public NettyServerSocketHandler(LaunchServer server) {
        this.server = server;
    }

    @Override
    public void close() {
    }

    public SSLContext SSLContextInit() throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        TrustManager[] trustAllCerts = new TrustManager[]{new LauncherTrustManager()};
        KeyStore ks = LauncherKeyStore.getKeyStore((String)"keystore", (String)"PSP1000");
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, "PSP1000".toCharArray());
        SSLContext sc = SSLContext.getInstance("TLSv1.2");
        sc.init(kmf.getKeyManagers(), trustAllCerts, new SecureRandom());
        return sc;
    }

    @Override
    public void run() {
        LogHelper.info((String)"Starting netty server socket thread");
        this.nettyServer = new LauncherNettyServer(this.server);
        for (LaunchServerConfig.NettyBindAddress address : this.server.config.netty.binds) {
            this.nettyServer.bind(new InetSocketAddress(address.address, address.port));
        }
    }
}

