/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.auth;

import io.netty.channel.ChannelHandlerContext;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.hwid.HWID;
import pro.gravit.launcher.hwid.OshiHWID;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.hwid.HWIDException;
import pro.gravit.launchserver.auth.provider.AuthProvider;
import pro.gravit.launchserver.auth.provider.AuthProviderResult;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.launchserver.socket.response.profile.ProfileByUUIDResponse;
import pro.gravit.utils.HookException;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.helper.VerifyHelper;

public class AuthResponse
extends SimpleResponse {
    public static transient Random random = new SecureRandom();
    public String login;
    public String client;
    public String customText;
    public boolean getSession;
    public String password;
    public byte[] encryptedPassword;
    public String auth_id;
    public ConnectTypes authType;
    public HWID hwid;

    public AuthResponse(String login, String password, String auth_id, OshiHWID hwid) {
        this.login = login;
        this.password = password;
        this.auth_id = auth_id;
        this.hwid = hwid;
    }

    @Override
    public String getType() {
        return "auth";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client clientData) throws Exception {
        try {
            AuthRequestEvent result = new AuthRequestEvent();
            if (!(this.authType != null && this.authType != ConnectTypes.CLIENT || clientData != null && clientData.checkSign)) {
                AuthProvider.authError("Don't skip Launcher Update");
                return;
            }
            if (this.password == null) {
                try {
                    this.password = IOHelper.decode((byte[])SecurityHelper.newRSADecryptCipher((RSAPrivateKey)this.server.privateKey).doFinal(this.encryptedPassword));
                }
                catch (BadPaddingException | IllegalBlockSizeException ignored) {
                    throw new AuthException("Password decryption error");
                }
            }
            AuthProviderPair pair = this.auth_id.isEmpty() ? this.server.config.getAuthProviderPair() : this.server.config.getAuthProviderPair(this.auth_id);
            AuthContext context = new AuthContext(0L, this.login, this.password.length(), this.customText, this.client, null, this.ip, this.authType);
            AuthProvider provider = pair.provider;
            this.server.authHookManager.preHook.hook((Object)context, (Object)clientData);
            provider.preAuth(this.login, this.password, this.customText, this.ip);
            AuthProviderResult aresult = provider.auth(this.login, this.password, this.ip);
            if (!VerifyHelper.isValidUsername((CharSequence)aresult.username)) {
                AuthProvider.authError(String.format("Illegal result: '%s'", aresult.username));
                return;
            }
            List<ClientProfile> profiles = this.server.getProfiles();
            for (ClientProfile p : profiles) {
                if (!p.getTitle().equals(this.client)) continue;
                if (!p.isWhitelistContains(this.login)) {
                    throw new AuthException(this.server.config.whitelistRejectString);
                }
                clientData.profile = p;
            }
            if (this.authType == ConnectTypes.CLIENT) {
                this.server.config.hwidHandler.check(this.hwid, aresult.username);
            }
            this.server.authHookManager.postHook.hook((Object)context, (Object)clientData);
            clientData.isAuth = true;
            clientData.permissions = aresult.permissions;
            clientData.auth_id = this.auth_id;
            clientData.updateAuth(this.server);
            clientData.username = result.playerProfile != null ? result.playerProfile.username : this.login;
            result.accessToken = aresult.accessToken;
            result.permissions = clientData.permissions;
            if (this.authType == ConnectTypes.SERVER && !clientData.permissions.canServer) {
                AuthProvider.authError("authType: SERVER not allowed for this account");
                return;
            }
            if (this.getSession) {
                if (clientData.session == 0L) {
                    clientData.session = random.nextLong();
                    this.server.sessionManager.addClient(clientData);
                }
                result.session = clientData.session;
            }
            if (this.authType != ConnectTypes.API && this.server.config.protectHandler.allowGetAccessToken(context)) {
                UUID uuid = pair.handler.auth(aresult);
                result.playerProfile = ProfileByUUIDResponse.getProfile(uuid, aresult.username, this.client, clientData.auth.textureProvider);
                if (LogHelper.isDebugEnabled()) {
                    LogHelper.debug((String)"Auth: %s accessToken %s uuid: %s", (Object[])new Object[]{this.login, result.accessToken, uuid.toString()});
                }
            }
            this.sendResult((RequestEvent)result);
        }
        catch (AuthException | HWIDException | HookException e) {
            this.sendError(e.getMessage());
        }
    }

    public static class AuthContext {
        public long session;
        public String login;
        public int password_length;
        public String client;
        public String hwid;
        public String customText;
        public String ip;
        public ConnectTypes authType;

        public AuthContext(long session, String login, int password_length, String customText, String client, String hwid, String ip, ConnectTypes authType) {
            this.session = session;
            this.login = login;
            this.password_length = password_length;
            this.customText = customText;
            this.client = client;
            this.hwid = hwid;
            this.ip = ip;
            this.authType = authType;
        }
    }

    public static enum ConnectTypes {
        SERVER,
        CLIENT,
        API;

    }
}

