/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.auth;

import io.netty.channel.ChannelHandlerContext;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.JoinServerRequestEvent;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.utils.HookException;
import pro.gravit.utils.helper.LogHelper;

public class JoinServerResponse
extends SimpleResponse {
    public String serverID;
    public String accessToken;
    public String username;

    @Override
    public String getType() {
        return "joinServer";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) {
        boolean success;
        try {
            this.server.authHookManager.joinServerHook.hook((Object)this, (Object)client);
            if (client.auth == null) {
                LogHelper.warning((String)"Client auth is null. Using default.");
                success = this.server.config.getAuthProviderPair().handler.joinServer(this.username, this.accessToken, this.serverID);
            } else {
                success = client.auth.handler.joinServer(this.username, this.accessToken, this.serverID);
            }
            if (LogHelper.isDebugEnabled()) {
                LogHelper.debug((String)"joinServer: %s accessToken: %s serverID: %s", (Object[])new Object[]{this.username, this.accessToken, this.serverID});
            }
        }
        catch (AuthException | HookException e) {
            this.sendError(e.getMessage());
            return;
        }
        catch (Exception e) {
            LogHelper.error((Throwable)e);
            this.sendError("Internal authHandler error");
            return;
        }
        this.sendResult((RequestEvent)new JoinServerRequestEvent(success));
    }
}

