/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.CRC32;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.operator.OperatorCreationException;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.NeedGarbageCollection;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.managers.ConfigManager;
import pro.gravit.launcher.managers.GarbageManager;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.events.ClosePhase;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launchserver.Reconfigurable;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.binary.EXEL4JLauncherBinary;
import pro.gravit.launchserver.binary.EXELauncherBinary;
import pro.gravit.launchserver.binary.JARLauncherBinary;
import pro.gravit.launchserver.binary.LauncherBinary;
import pro.gravit.launchserver.binary.ProguardConf;
import pro.gravit.launchserver.binary.SimpleEXELauncherBinary;
import pro.gravit.launchserver.command.handler.CommandHandler;
import pro.gravit.launchserver.config.LaunchServerConfig;
import pro.gravit.launchserver.config.LaunchServerRuntimeConfig;
import pro.gravit.launchserver.manangers.CertificateManager;
import pro.gravit.launchserver.manangers.MirrorManager;
import pro.gravit.launchserver.manangers.ReconfigurableManager;
import pro.gravit.launchserver.manangers.SessionManager;
import pro.gravit.launchserver.manangers.hook.AuthHookManager;
import pro.gravit.launchserver.manangers.hook.BuildHookManager;
import pro.gravit.launchserver.modules.events.LaunchServerFullInitEvent;
import pro.gravit.launchserver.modules.events.LaunchServerInitPhase;
import pro.gravit.launchserver.modules.events.LaunchServerPostInitPhase;
import pro.gravit.launchserver.modules.events.NewLaunchServerInstanceEvent;
import pro.gravit.launchserver.modules.impl.LaunchServerModulesManager;
import pro.gravit.launchserver.socket.handlers.NettyServerSocketHandler;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.SubCommand;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public final class LaunchServer
implements Runnable,
AutoCloseable,
Reconfigurable {
    public final Path dir;
    public final LaunchServerEnv env;
    public final Path launcherLibraries;
    public final Path launcherLibrariesCompile;
    public final Path caCertFile;
    public final Path caKeyFile;
    public final Path serverCertFile;
    public final Path serverKeyFile;
    public final Path updatesDir;
    public final LaunchServerConfigManager launchServerConfigManager;
    public final Path profilesDir;
    public LaunchServerConfig config;
    public LaunchServerRuntimeConfig runtime;
    public final RSAPublicKey publicKey;
    public final RSAPrivateKey privateKey;
    public final JARLauncherBinary launcherBinary;
    public Class<? extends LauncherBinary> launcherEXEBinaryClass;
    public final LauncherBinary launcherEXEBinary;
    public final SessionManager sessionManager;
    public final AuthHookManager authHookManager;
    public final LaunchServerModulesManager modulesManager;
    public final MirrorManager mirrorManager;
    public final ReconfigurableManager reconfigurableManager;
    public final ConfigManager configManager;
    public final CertificateManager certificateManager;
    public final BuildHookManager buildHookManager;
    public final ProguardConf proguardConf;
    public final pro.gravit.utils.command.CommandHandler commandHandler;
    public final NettyServerSocketHandler nettyServerSocketHandler;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private volatile List<ClientProfile> profilesList;
    public volatile Map<String, HashedDir> updatesDirMap;
    public final Timer taskPool;
    public static Class<? extends LauncherBinary> defaultLauncherEXEBinaryClass = null;

    public void reload(ReloadType type) throws Exception {
        this.config.close(type);
        AuthProviderPair[] pairs = null;
        if (type.equals((Object)ReloadType.NO_AUTH)) {
            pairs = this.config.auth;
        }
        LogHelper.info((String)"Reading LaunchServer config file");
        this.config = this.launchServerConfigManager.readConfig();
        this.config.setLaunchServer(this);
        if (type.equals((Object)ReloadType.NO_AUTH)) {
            this.config.auth = pairs;
        }
        this.config.verify();
        this.config.init(type);
        if (type.equals((Object)ReloadType.FULL) && this.config.components != null) {
            LogHelper.debug((String)"PreInit components");
            this.config.components.forEach((k, v) -> {
                LogHelper.subDebug((String)"PreInit component %s", (Object[])new Object[]{k});
                v.preInit(this);
            });
            LogHelper.debug((String)"PreInit components successful");
            LogHelper.debug((String)"Init components");
            this.config.components.forEach((k, v) -> {
                LogHelper.subDebug((String)"Init component %s", (Object[])new Object[]{k});
                this.registerObject("component.".concat((String)k), v);
                v.init(this);
            });
            LogHelper.debug((String)"Init components successful");
            LogHelper.debug((String)"PostInit components");
            this.config.components.forEach((k, v) -> {
                LogHelper.subDebug((String)"PostInit component %s", (Object[])new Object[]{k});
                v.postInit(this);
            });
            LogHelper.debug((String)"PostInit components successful");
        }
    }

    @Override
    public Map<String, Command> getCommands() {
        HashMap<String, Command> commands = new HashMap<String, Command>();
        SubCommand reload = new SubCommand(){

            public void invoke(String ... args) throws Exception {
                if (args.length == 0) {
                    LaunchServer.this.reload(ReloadType.FULL);
                    return;
                }
                switch (args[0]) {
                    case "full": {
                        LaunchServer.this.reload(ReloadType.FULL);
                        break;
                    }
                    case "no_auth": {
                        LaunchServer.this.reload(ReloadType.NO_AUTH);
                        break;
                    }
                    case "no_components": {
                        LaunchServer.this.reload(ReloadType.NO_COMPONENTS);
                        break;
                    }
                    default: {
                        LaunchServer.this.reload(ReloadType.FULL);
                    }
                }
            }
        };
        commands.put("reload", (Command)reload);
        return commands;
    }

    public LaunchServer(LaunchServerDirectories directories, LaunchServerEnv env, LaunchServerConfig config, LaunchServerRuntimeConfig runtimeConfig, LaunchServerConfigManager launchServerConfigManager, LaunchServerModulesManager modulesManager, RSAPublicKey publicKey, RSAPrivateKey privateKey, pro.gravit.utils.command.CommandHandler commandHandler) throws IOException, InvalidKeySpecException {
        this.dir = directories.dir;
        this.env = env;
        this.config = config;
        this.launchServerConfigManager = launchServerConfigManager;
        this.modulesManager = modulesManager;
        this.profilesDir = directories.profilesDir;
        this.updatesDir = directories.updatesDir;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.commandHandler = commandHandler;
        this.runtime = runtimeConfig;
        this.taskPool = new Timer("Timered task worker thread", true);
        this.launcherLibraries = this.dir.resolve("launcher-libraries");
        this.launcherLibrariesCompile = this.dir.resolve("launcher-libraries-compile");
        config.setLaunchServer(this);
        this.caCertFile = this.dir.resolve("ca.crt");
        this.caKeyFile = this.dir.resolve("ca.key");
        this.serverCertFile = this.dir.resolve("server.crt");
        this.serverKeyFile = this.dir.resolve("server.key");
        modulesManager.invokeEvent(new NewLaunchServerInstanceEvent(this));
        CRC32 crc = new CRC32();
        crc.update(publicKey.getModulus().toByteArray());
        LogHelper.subInfo((String)"Modulus CRC32: 0x%08x", (Object[])new Object[]{crc.getValue()});
        this.launcherEXEBinaryClass = defaultLauncherEXEBinaryClass;
        this.runtime.verify();
        config.verify();
        if (config.components != null) {
            LogHelper.debug((String)"PreInit components");
            config.components.forEach((k, v) -> {
                LogHelper.subDebug((String)"PreInit component %s", (Object[])new Object[]{k});
                v.preInit(this);
            });
            LogHelper.debug((String)"PreInit components successful");
        }
        this.buildHookManager = new BuildHookManager();
        this.proguardConf = new ProguardConf(this);
        this.sessionManager = new SessionManager();
        this.mirrorManager = new MirrorManager();
        this.reconfigurableManager = new ReconfigurableManager();
        this.authHookManager = new AuthHookManager();
        this.configManager = new ConfigManager();
        this.certificateManager = new CertificateManager();
        this.certificateManager.orgName = config.projectName;
        if (config.certificate != null && config.certificate.enabled) {
            if (IOHelper.isFile((Path)this.caCertFile) && IOHelper.isFile((Path)this.caKeyFile)) {
                this.certificateManager.ca = this.certificateManager.readCertificate(this.caCertFile);
                this.certificateManager.caKey = this.certificateManager.readPrivateKey(this.caKeyFile);
            } else {
                try {
                    this.certificateManager.generateCA();
                    this.certificateManager.writeCertificate(this.caCertFile, this.certificateManager.ca);
                    this.certificateManager.writePrivateKey(this.caKeyFile, this.certificateManager.caKey);
                }
                catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | OperatorCreationException e) {
                    LogHelper.error((Throwable)e);
                }
            }
            if (IOHelper.isFile((Path)this.serverCertFile) && IOHelper.isFile((Path)this.serverKeyFile)) {
                this.certificateManager.server = this.certificateManager.readCertificate(this.serverCertFile);
                this.certificateManager.serverKey = this.certificateManager.readPrivateKey(this.serverKeyFile);
            } else {
                try {
                    KeyPair pair = this.certificateManager.generateKeyPair();
                    this.certificateManager.server = this.certificateManager.generateCertificate(config.projectName.concat(" Server"), pair.getPublic());
                    this.certificateManager.serverKey = PrivateKeyFactory.createKey((byte[])pair.getPrivate().getEncoded());
                    this.certificateManager.writePrivateKey(this.serverKeyFile, pair.getPrivate());
                    this.certificateManager.writeCertificate(this.serverCertFile, this.certificateManager.server);
                }
                catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | OperatorCreationException e) {
                    LogHelper.error((Throwable)e);
                }
            }
        }
        config.init(ReloadType.FULL);
        this.registerObject("launchServer", this);
        GarbageManager.registerNeedGC((NeedGarbageCollection)this.sessionManager);
        CommandHandler.registerCommands(commandHandler, this);
        modulesManager.invokeEvent((LauncherModule.Event)new LaunchServerInitPhase(this));
        if (config.components != null) {
            LogHelper.debug((String)"Init components");
            config.components.forEach((k, v) -> {
                LogHelper.subDebug((String)"Init component %s", (Object[])new Object[]{k});
                v.init(this);
            });
            LogHelper.debug((String)"Init components successful");
        }
        this.launcherBinary = new JARLauncherBinary(this);
        this.launcherEXEBinary = this.binary();
        this.launcherBinary.init();
        this.launcherEXEBinary.init();
        this.syncLauncherBinaries();
        if (!IOHelper.isDir((Path)this.updatesDir)) {
            Files.createDirectory(this.updatesDir, new FileAttribute[0]);
        }
        this.syncUpdatesDir(null);
        if (!IOHelper.isDir((Path)this.profilesDir)) {
            Files.createDirectory(this.profilesDir, new FileAttribute[0]);
        }
        this.syncProfilesDir();
        modulesManager.invokeEvent((LauncherModule.Event)new LaunchServerPostInitPhase(this));
        if (config.components != null) {
            LogHelper.debug((String)"PostInit components");
            config.components.forEach((k, v) -> {
                LogHelper.subDebug((String)"PostInit component %s", (Object[])new Object[]{k});
                v.postInit(this);
            });
            LogHelper.debug((String)"PostInit components successful");
        }
        this.nettyServerSocketHandler = config.netty != null ? new NettyServerSocketHandler(this) : null;
    }

    private LauncherBinary binary() {
        if (this.launcherEXEBinaryClass != null) {
            try {
                return this.launcherEXEBinaryClass.getConstructor(LaunchServer.class).newInstance(this);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LogHelper.error((Throwable)e);
            }
        }
        if (this.config.launch4j.alternative != null) {
            switch (this.config.launch4j.alternative) {
                case "simple": {
                    return new SimpleEXELauncherBinary(this);
                }
                case "no": {
                    break;
                }
                default: {
                    LogHelper.warning((String)"Alternative %s not found", (Object[])new Object[]{this.config.launch4j.alternative});
                }
            }
        }
        try {
            Class.forName("net.sf.launch4j.Builder");
            if (this.config.launch4j.enabled) {
                return new EXEL4JLauncherBinary(this);
            }
        }
        catch (ClassNotFoundException ignored) {
            LogHelper.warning((String)"Launch4J isn't in classpath.");
        }
        return new EXELauncherBinary(this);
    }

    public void buildLauncherBinaries() throws IOException {
        this.launcherBinary.build();
        this.launcherEXEBinary.build();
    }

    @Override
    public void close() throws Exception {
        this.config.close(ReloadType.FULL);
        this.modulesManager.invokeEvent((LauncherModule.Event)new ClosePhase());
        LogHelper.info((String)"Save LaunchServer runtime config");
        this.launchServerConfigManager.writeRuntimeConfig(this.runtime);
        LogHelper.info((String)"LaunchServer stopped");
    }

    public List<ClientProfile> getProfiles() {
        return this.profilesList;
    }

    public void setProfiles(List<ClientProfile> profilesList) {
        this.profilesList = Collections.unmodifiableList(profilesList);
    }

    public HashedDir getUpdateDir(String name) {
        return this.updatesDirMap.get(name);
    }

    public Set<Map.Entry<String, HashedDir>> getUpdateDirs() {
        return this.updatesDirMap.entrySet();
    }

    public void rebindNettyServerSocket() {
        this.nettyServerSocketHandler.close();
        CommonHelper.newThread((String)"Netty Server Socket Thread", (boolean)false, (Runnable)this.nettyServerSocketHandler).start();
    }

    @Override
    public void run() {
        if (this.started.getAndSet(true)) {
            throw new IllegalStateException("LaunchServer has been already started");
        }
        if (!this.env.equals((Object)LaunchServerEnv.TEST)) {
            JVMHelper.RUNTIME.addShutdownHook(CommonHelper.newThread(null, (boolean)false, () -> {
                try {
                    this.close();
                }
                catch (Exception e) {
                    LogHelper.error((Throwable)e);
                }
            }));
            CommonHelper.newThread((String)"Command Thread", (boolean)true, (Runnable)this.commandHandler).start();
        }
        if (this.config.netty != null) {
            this.rebindNettyServerSocket();
        }
        this.modulesManager.fullInitializedLaunchServer(this);
        this.modulesManager.invokeEvent(new LaunchServerFullInitEvent(this));
    }

    public void syncLauncherBinaries() throws IOException {
        LogHelper.info((String)"Syncing launcher binaries");
        LogHelper.info((String)"Syncing launcher binary file");
        if (!this.launcherBinary.sync()) {
            LogHelper.warning((String)"Missing launcher binary file");
        }
        LogHelper.info((String)"Syncing launcher EXE binary file");
        if (!this.launcherEXEBinary.sync() && this.config.launch4j.enabled) {
            LogHelper.warning((String)"Missing launcher EXE binary file");
        }
    }

    public void syncProfilesDir() throws IOException {
        LogHelper.info((String)"Syncing profiles dir");
        LinkedList<ClientProfile> newProfies = new LinkedList<ClientProfile>();
        IOHelper.walk((Path)this.profilesDir, (FileVisitor)new ProfilesFileVisitor(newProfies), (boolean)false);
        newProfies.sort(Comparator.comparing(a -> a));
        this.profilesList = Collections.unmodifiableList(newProfies);
    }

    public void syncUpdatesDir(Collection<String> dirs) throws IOException {
        LogHelper.info((String)"Syncing updates dir");
        HashMap<String, HashedDir> newUpdatesDirMap = new HashMap<String, HashedDir>(16);
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(this.updatesDir);){
            for (Path updateDir : dirStream) {
                HashedDir hdir;
                if (Files.isHidden(updateDir)) continue;
                String name = IOHelper.getFileName((Path)updateDir);
                if (!IOHelper.isDir((Path)updateDir)) {
                    if (IOHelper.isFile((Path)updateDir) || !Arrays.asList(".jar", ".exe", ".hash").stream().noneMatch(e -> updateDir.toString().endsWith((String)e))) continue;
                    LogHelper.warning((String)"Not update dir: '%s'", (Object[])new Object[]{name});
                    continue;
                }
                if (dirs != null && !dirs.contains(name) && (hdir = this.updatesDirMap.get(name)) != null) {
                    newUpdatesDirMap.put(name, hdir);
                    continue;
                }
                LogHelper.info((String)"Syncing '%s' update dir", (Object[])new Object[]{name});
                HashedDir updateHDir = new HashedDir(updateDir, null, true, true);
                newUpdatesDirMap.put(name, updateHDir);
            }
        }
        this.updatesDirMap = Collections.unmodifiableMap(newUpdatesDirMap);
    }

    public void restart() {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        if (this.config.startScript == null) {
            throw new IllegalArgumentException("Please create start script and link it as startScript in config.");
        }
        builder.command(Collections.singletonList(this.config.startScript));
        builder.directory(this.dir.toFile());
        builder.inheritIO();
        builder.redirectErrorStream(true);
        builder.redirectOutput(ProcessBuilder.Redirect.PIPE);
        try {
            builder.start();
        }
        catch (IOException e) {
            LogHelper.error((Throwable)e);
        }
    }

    public void registerObject(String name, Object object) {
        if (object instanceof Reconfigurable) {
            this.reconfigurableManager.registerReconfigurable(name, (Reconfigurable)object);
        }
        if (object instanceof NeedGarbageCollection) {
            GarbageManager.registerNeedGC((NeedGarbageCollection)((NeedGarbageCollection)object));
        }
    }

    public void unregisterObject(String name, Object object) {
        if (object instanceof Reconfigurable) {
            this.reconfigurableManager.unregisterReconfigurable(name);
        }
        if (object instanceof NeedGarbageCollection) {
            GarbageManager.unregisterNeedGC((NeedGarbageCollection)((NeedGarbageCollection)object));
        }
    }

    public void fullyRestart() {
        this.restart();
        JVMHelper.RUNTIME.exit(0);
    }

    public static class LaunchServerDirectories {
        public Path updatesDir;
        public Path profilesDir;
        public Path dir;

        public void collect() {
            if (this.updatesDir == null) {
                this.updatesDir = this.dir.resolve("updates");
            }
            if (this.profilesDir == null) {
                this.profilesDir = this.dir.resolve("profiles");
            }
        }
    }

    private final class ProfilesFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Collection<ClientProfile> result;

        private ProfilesFileVisitor(Collection<ClientProfile> result) {
            this.result = result;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            ClientProfile profile;
            LogHelper.info((String)"Syncing '%s' profile", (Object[])new Object[]{IOHelper.getFileName((Path)file)});
            try (BufferedReader reader = IOHelper.newReader((Path)file);){
                profile = (ClientProfile)Launcher.gsonManager.gson.fromJson((Reader)reader, ClientProfile.class);
            }
            profile.verify();
            this.result.add(profile);
            return super.visitFile(file, attrs);
        }
    }

    public static interface LaunchServerConfigManager {
        public LaunchServerConfig readConfig() throws IOException;

        public LaunchServerRuntimeConfig readRuntimeConfig() throws IOException;

        public void writeConfig(LaunchServerConfig var1) throws IOException;

        public void writeRuntimeConfig(LaunchServerRuntimeConfig var1) throws IOException;
    }

    public static enum LaunchServerEnv {
        TEST,
        DEV,
        DEBUG,
        PRODUCTION;

    }

    public static enum ReloadType {
        NO_AUTH,
        NO_COMPONENTS,
        FULL;

    }
}

