/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.handler;

import java.io.IOException;
import java.util.UUID;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.handler.HibernateAuthHandler;
import pro.gravit.launchserver.auth.handler.JsonAuthHandler;
import pro.gravit.launchserver.auth.handler.MemoryAuthHandler;
import pro.gravit.launchserver.auth.handler.MySQLAuthHandler;
import pro.gravit.launchserver.auth.handler.NullAuthHandler;
import pro.gravit.launchserver.auth.handler.PostgreSQLAuthHandler;
import pro.gravit.launchserver.auth.handler.RequestAuthHandler;
import pro.gravit.launchserver.auth.provider.AuthProviderResult;
import pro.gravit.utils.ProviderMap;

public abstract class AuthHandler
implements AutoCloseable {
    public static ProviderMap<AuthHandler> providers = new ProviderMap("AuthHandler");
    private static boolean registredHandl = false;
    protected transient LaunchServer srv;

    public static UUID authError(String message) throws AuthException {
        throw new AuthException(message);
    }

    public static void registerHandlers() {
        if (!registredHandl) {
            providers.register("null", NullAuthHandler.class);
            providers.register("json", JsonAuthHandler.class);
            providers.register("memory", MemoryAuthHandler.class);
            providers.register("mysql", MySQLAuthHandler.class);
            providers.register("postgresql", PostgreSQLAuthHandler.class);
            providers.register("request", RequestAuthHandler.class);
            providers.register("hibernate", HibernateAuthHandler.class);
            registredHandl = true;
        }
    }

    public abstract UUID auth(AuthProviderResult var1) throws IOException;

    public abstract UUID checkServer(String var1, String var2) throws IOException;

    @Override
    public abstract void close() throws IOException;

    public abstract boolean joinServer(String var1, String var2, String var3) throws IOException;

    public abstract UUID usernameToUUID(String var1) throws IOException;

    public abstract String uuidToUsername(UUID var1) throws IOException;

    public void init(LaunchServer srv) {
        this.srv = srv;
    }
}

