/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.permissions;

import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launcher.Launcher;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.Reconfigurable;
import pro.gravit.launchserver.auth.permissions.PermissionsHandler;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.SubCommand;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class JsonFilePermissionsHandler
extends PermissionsHandler
implements Reconfigurable {
    public String filename = "permissions.json";
    public static Map<String, ClientPermissions> map;

    public void reload() {
        map.clear();
        Path path = Paths.get(this.filename, new String[0]);
        Type type = new TypeToken<Map<String, ClientPermissions>>(){}.getType();
        try (BufferedReader reader = IOHelper.newReader((Path)path);){
            map = (Map)Launcher.gsonManager.gson.fromJson((Reader)reader, type);
        }
        catch (IOException e) {
            LogHelper.error((Throwable)e);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public Map<String, Command> getCommands() {
        HashMap<String, Command> commands = new HashMap<String, Command>();
        SubCommand reload = new SubCommand(){

            public void invoke(String ... args) throws Exception {
                JsonFilePermissionsHandler.this.reload();
            }
        };
        commands.put("reload", (Command)reload);
        commands.put("save", (Command)new SubCommand(){

            public void invoke(String ... args) throws Exception {
                Path path = Paths.get(JsonFilePermissionsHandler.this.filename, new String[0]);
                if (!IOHelper.exists((Path)path)) {
                    try (BufferedWriter writer = IOHelper.newWriter((Path)path);){
                        Launcher.gsonManager.gson.toJson(map, (Appendable)writer);
                    }
                    catch (IOException e) {
                        LogHelper.error((Throwable)e);
                    }
                }
            }
        });
        return commands;
    }

    @Override
    public void init(LaunchServer server) {
        Throwable throwable;
        super.init(server);
        Type type = new TypeToken<Map<String, ClientPermissions>>(){}.getType();
        Path path = Paths.get(this.filename, new String[0]);
        if (!IOHelper.exists((Path)path)) {
            map = new HashMap<String, ClientPermissions>();
            try {
                throwable = null;
                try (BufferedWriter writer = IOHelper.newWriter((Path)path);){
                    Launcher.gsonManager.gson.toJson(map, (Appendable)writer);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e) {
                LogHelper.error((Throwable)e);
            }
        }
        try {
            throwable = null;
            try (BufferedReader reader = IOHelper.newReader((Path)path);){
                map = (Map)Launcher.gsonManager.gson.fromJson((Reader)reader, type);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            LogHelper.error((Throwable)e);
        }
    }

    @Override
    public ClientPermissions getPermissions(String username) {
        return map.getOrDefault(username, ClientPermissions.DEFAULT);
    }

    @Override
    public void setPermissions(String username, ClientPermissions permissions) {
        map.put(username, permissions);
    }

    public static class Enity {
        public String username;
        public ClientPermissions permissions;
    }
}

