/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import pro.gravit.launchserver.binary.LauncherConfigurator;
import pro.gravit.launchserver.binary.tasks.MainBuildTask;
import pro.gravit.utils.helper.IOHelper;

public class BuildContext {
    public final ZipOutputStream output;
    public final LauncherConfigurator config;
    public final MainBuildTask data;
    public final HashSet<String> fileList;

    public BuildContext(ZipOutputStream output, LauncherConfigurator config, MainBuildTask data) {
        this.output = output;
        this.config = config;
        this.data = data;
        this.fileList = new HashSet(1024);
    }

    public void pushFile(String filename, InputStream inputStream) throws IOException {
        ZipEntry zip = IOHelper.newZipEntry((String)filename);
        this.output.putNextEntry(zip);
        IOHelper.transfer((InputStream)inputStream, (OutputStream)this.output);
        this.fileList.add(filename);
    }

    public void pushJarFile(ZipInputStream input) throws IOException {
        ZipEntry e = input.getNextEntry();
        while (e != null) {
            if (this.fileList.contains(e.getName())) {
                e = input.getNextEntry();
                continue;
            }
            this.output.putNextEntry(IOHelper.newZipEntry((ZipEntry)e));
            IOHelper.transfer((InputStream)input, (OutputStream)this.output);
            this.fileList.add(e.getName());
            e = input.getNextEntry();
        }
    }

    public void pushJarFile(ZipInputStream input, Set<String> blacklist) throws IOException {
        ZipEntry e = input.getNextEntry();
        while (e != null) {
            if (blacklist.contains(e.getName())) {
                e = input.getNextEntry();
                continue;
            }
            this.output.putNextEntry(IOHelper.newZipEntry((ZipEntry)e));
            IOHelper.transfer((InputStream)input, (OutputStream)this.output);
            this.fileList.add(e.getName());
            e = input.getNextEntry();
        }
    }
}

