/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.ArrayList;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.helper.UnpackHelper;

public class ProguardConf {
    private static final String chars = "1aAbBcC2dDeEfF3gGhHiI4jJkKl5mMnNoO6pPqQrR7sStT8uUvV9wWxX0yYzZ";
    public final Path proguard;
    public final Path config;
    public final Path mappings;
    public final Path words;
    public final transient LaunchServer srv;

    private static String generateString(SecureRandom rand, String lowString, String upString, int il) {
        StringBuilder sb = new StringBuilder(Math.max(il, lowString.length()));
        for (int i = 0; i < lowString.length(); ++i) {
            sb.append(rand.nextBoolean() ? lowString.charAt(i) : upString.charAt(i));
        }
        int toI = il - lowString.length();
        for (int i = 0; i < toI; ++i) {
            sb.append(chars.charAt(rand.nextInt(chars.length())));
        }
        return sb.toString();
    }

    public ProguardConf(LaunchServer srv) {
        this.proguard = srv.dir.resolve("proguard");
        this.config = this.proguard.resolve("proguard.config");
        this.mappings = this.proguard.resolve("mappings.pro");
        this.words = this.proguard.resolve("random.pro");
        this.srv = srv;
    }

    public String[] buildConfig(Path inputJar, Path outputJar) {
        ArrayList<String> confStrs = new ArrayList<String>();
        this.prepare(false);
        if (this.srv.config.launcher.proguardGenMappings) {
            confStrs.add("-printmapping '" + this.mappings.toFile().getName() + "'");
        }
        confStrs.add("-obfuscationdictionary '" + this.words.toFile().getName() + "'");
        confStrs.add("-injar '" + inputJar.toAbsolutePath() + "'");
        confStrs.add("-outjar '" + outputJar.toAbsolutePath() + "'");
        this.srv.launcherBinary.coreLibs.stream().map(e -> "-libraryjars '" + e.toAbsolutePath().toString() + "'").forEach(confStrs::add);
        this.srv.launcherBinary.addonLibs.stream().map(e -> "-libraryjars '" + e.toAbsolutePath().toString() + "'").forEach(confStrs::add);
        confStrs.add("-classobfuscationdictionary '" + this.words.toFile().getName() + "'");
        confStrs.add(this.readConf());
        return confStrs.toArray(new String[0]);
    }

    private void genConfig(boolean force) throws IOException {
        if (IOHelper.exists((Path)this.config) && !force) {
            return;
        }
        Files.deleteIfExists(this.config);
        UnpackHelper.unpack((URL)IOHelper.getResourceURL((String)"pro/gravit/launchserver/defaults/proguard.cfg"), (Path)this.config);
    }

    public void genWords(boolean force) throws IOException {
        if (IOHelper.exists((Path)this.words) && !force) {
            return;
        }
        Files.deleteIfExists(this.words);
        SecureRandom rand = SecurityHelper.newRandom();
        rand.setSeed(SecureRandom.getSeed(32));
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter(IOHelper.newOutput((Path)this.words), IOHelper.UNICODE_CHARSET));){
            String projectName = this.srv.config.projectName.replaceAll("\\W", "");
            String lowName = projectName.toLowerCase();
            String upName = projectName.toUpperCase();
            for (int i = 0; i < Short.MAX_VALUE; ++i) {
                out.println(ProguardConf.generateString(rand, lowName, upName, 14));
            }
        }
    }

    public void prepare(boolean force) {
        try {
            IOHelper.createParentDirs((Path)this.config);
            this.genWords(force);
            this.genConfig(force);
        }
        catch (IOException e) {
            LogHelper.error((Throwable)e);
        }
    }

    private String readConf() {
        return "@".concat(this.config.toFile().getName());
    }
}

