/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.auth;

import java.io.IOException;
import java.util.UUID;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.command.Command;
import pro.gravit.utils.command.CommandException;
import pro.gravit.utils.helper.LogHelper;

public final class UsernameToUUIDCommand
extends Command {
    public UsernameToUUIDCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "<username> <auth_id>";
    }

    public String getUsageDescription() {
        return "Convert player username to UUID";
    }

    public void invoke(String ... args) throws CommandException, IOException {
        this.verifyArgs(args, 1);
        AuthProviderPair pair = args.length > 1 ? this.server.config.getAuthProviderPair(args[1]) : this.server.config.getAuthProviderPair();
        if (pair == null) {
            throw new IllegalStateException(String.format("Auth %s not found", args[1]));
        }
        String username = UsernameToUUIDCommand.parseUsername((String)args[0]);
        UUID uuid = pair.handler.usernameToUUID(username);
        if (uuid == null) {
            throw new CommandException(String.format("Unknown username: '%s'", username));
        }
        LogHelper.subInfo((String)"UUID of player '%s': %s", (Object[])new Object[]{username, uuid});
    }
}

